/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.collection;

import java.util.Iterator;

public class EnumSet<T extends Enum<T>>
implements Iterable<T> {
    private int i;
    private T[] set;
    private EnumSetIterator iterator = new EnumSetIterator();

    private EnumSet() {
    }

    public static <T extends Enum<T>> EnumSet<T> of(T ... arr) {
        EnumSet<T> set = new EnumSet<T>();
        set.set = arr;
        for (T t : arr) {
            set.i |= 1 << ((Enum)t).ordinal();
        }
        return set;
    }

    public boolean contains(T t) {
        return (this.i & 1 << ((Enum)t).ordinal()) != 0;
    }

    public int size() {
        return this.set.length;
    }

    @Override
    public Iterator<T> iterator() {
        this.iterator.index = 0;
        return this.iterator;
    }

    class EnumSetIterator
    implements Iterator<T> {
        int index = 0;

        EnumSetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < EnumSet.this.set.length;
        }

        @Override
        public T next() {
            if (this.index >= EnumSet.this.set.length) {
                return null;
            }
            return EnumSet.this.set[this.index++];
        }
    }
}

