/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl.audio;

import io.anuke.arc.audio.Sound;
import io.anuke.arc.backends.sdl.audio.ALAudio;
import io.anuke.arc.backends.sdl.jni.AL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ALSound
implements Sound {
    private final ALAudio audio;
    private int bufferID = -1;
    private float duration;

    public ALSound(ALAudio audio) {
        this.audio = audio;
    }

    void setup(byte[] pcm, int channels, int sampleRate) {
        int bytes = pcm.length - pcm.length % (channels > 1 ? 4 : 2);
        int samples = bytes / (2 * channels);
        this.duration = (float)samples / (float)sampleRate;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes);
        buffer.order(ByteOrder.nativeOrder());
        buffer.put(pcm, 0, bytes);
        buffer.flip();
        if (this.bufferID == -1) {
            this.bufferID = AL.alGenBuffers();
            AL.alBufferData(this.bufferID, channels > 1 ? 4355 : 4353, buffer, buffer.remaining(), sampleRate);
        }
    }

    @Override
    public int play(float volume) {
        if (this.audio.noDevice) {
            return 0;
        }
        int sourceID = this.audio.obtainSource(false);
        if (sourceID == -1) {
            this.audio.retain(this, true);
            sourceID = this.audio.obtainSource(false);
        } else {
            this.audio.retain(this, false);
        }
        if (sourceID == -1) {
            return -1;
        }
        int soundId = this.audio.getSoundId(sourceID);
        AL.alSourcei(sourceID, 4105, this.bufferID);
        AL.alSourcei(sourceID, 4103, 0);
        AL.alSourcef(sourceID, 4106, volume);
        AL.alSourcePlay(sourceID);
        return soundId;
    }

    @Override
    public int loop() {
        return this.loop(1.0f);
    }

    @Override
    public int loop(float volume) {
        if (this.audio.noDevice) {
            return 0;
        }
        int sourceID = this.audio.obtainSource(false);
        if (sourceID == -1) {
            return -1;
        }
        int soundId = this.audio.getSoundId(sourceID);
        AL.alSourcei(sourceID, 4105, this.bufferID);
        AL.alSourcei(sourceID, 4103, 1);
        AL.alSourcef(sourceID, 4106, volume);
        AL.alSourcePlay(sourceID);
        return soundId;
    }

    @Override
    public void stop() {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.stopSourcesWithBuffer(this.bufferID);
    }

    @Override
    public void dispose() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.bufferID == -1) {
            return;
        }
        this.audio.freeBuffer(this.bufferID);
        AL.alDeleteBuffers(this.bufferID);
        this.bufferID = -1;
        this.audio.forget(this);
    }

    @Override
    public void stop(int soundId) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.stopSound(soundId);
    }

    @Override
    public void pause() {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.pauseSourcesWithBuffer(this.bufferID);
    }

    @Override
    public void pause(int soundId) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.pauseSound(soundId);
    }

    @Override
    public void resume() {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.resumeSourcesWithBuffer(this.bufferID);
    }

    @Override
    public void resume(int soundId) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.resumeSound(soundId);
    }

    @Override
    public void setPitch(int soundId, float pitch) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundPitch(soundId, pitch);
    }

    @Override
    public void setVolume(int soundId, float volume) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundGain(soundId, volume);
    }

    @Override
    public void setLooping(int soundId, boolean looping) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundLooping(soundId, looping);
    }

    @Override
    public void setPan(int soundId, float pan, float volume) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundPan(soundId, pan, volume);
    }

    @Override
    public int play(float volume, float pitch, float pan) {
        int id = this.play();
        this.setPitch(id, pitch);
        this.setPan(id, pan, volume);
        return id;
    }

    @Override
    public int loop(float volume, float pitch, float pan) {
        int id = this.loop();
        this.setPitch(id, pitch);
        this.setPan(id, pan, volume);
        return id;
    }

    public float duration() {
        return this.duration;
    }
}

