/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl.audio;

import io.anuke.arc.audio.Music;
import io.anuke.arc.backends.sdl.audio.ALAudio;
import io.anuke.arc.backends.sdl.jni.AL;
import io.anuke.arc.collection.FloatArray;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.ArcRuntimeException;
import io.anuke.arc.util.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public abstract class ALMusic
implements Music {
    private static final int bufferSize = 40960;
    private static final int bufferCount = 3;
    private static final int bytesPerSample = 2;
    private static final byte[] tempBytes = new byte[40960];
    private static final ByteBuffer tempBuffer = BufferUtils.newByteBuffer(40960);
    protected final FileHandle file;
    private final ALAudio audio;
    protected int bufferOverhead = 0;
    private FloatArray renderedSecondsQueue = new FloatArray(3);
    private IntBuffer buffers;
    private int sourceID = -1;
    private int format;
    private int sampleRate;
    private boolean isLooping;
    private boolean isPlaying;
    private float volume = 1.0f;
    private float pan = 0.0f;
    private float renderedSeconds;
    private float maxSecondsPerBuffer;
    private Music.OnCompletionListener onCompletionListener;

    public ALMusic(ALAudio audio, FileHandle file) {
        this.audio = audio;
        this.file = file;
        this.onCompletionListener = null;
    }

    protected void setup(int channels, int sampleRate) {
        this.format = channels > 1 ? 4355 : 4353;
        this.sampleRate = sampleRate;
        this.maxSecondsPerBuffer = (float)(40960 - this.bufferOverhead) / (float)(2 * channels * sampleRate);
    }

    @Override
    public void play() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            int bufferID;
            this.sourceID = this.audio.obtainSource(true);
            if (this.sourceID == -1) {
                return;
            }
            this.audio.music.add(this);
            if (this.buffers == null) {
                this.buffers = BufferUtils.newIntBuffer(3);
                AL.alGenBuffers(this.buffers.remaining(), this.buffers);
                int errorCode = AL.alGetError();
                if (errorCode != 0) {
                    throw new ArcRuntimeException("Unable to allocate audio buffers. AL Error: " + errorCode);
                }
            }
            AL.alSourcei(this.sourceID, 4147, 1);
            AL.alSourcei(this.sourceID, 4103, 0);
            this.setPan(this.pan, this.volume);
            boolean filled = false;
            for (int i = 0; i < 3 && this.fill(bufferID = this.buffers.get(i)); ++i) {
                filled = true;
                AL.alSourceQueueBuffers(this.sourceID, bufferID);
            }
            if (!filled && this.onCompletionListener != null) {
                this.onCompletionListener.complete(this);
            }
            if (AL.alGetError() != 0) {
                this.stop();
                return;
            }
        }
        if (!this.isPlaying) {
            AL.alSourcePlay(this.sourceID);
            this.isPlaying = true;
        }
    }

    @Override
    public void stop() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        this.audio.music.removeValue(this, true);
        this.reset();
        this.audio.freeSource(this.sourceID);
        this.sourceID = -1;
        this.renderedSeconds = 0.0f;
        this.renderedSecondsQueue.clear();
        this.isPlaying = false;
    }

    @Override
    public void pause() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID != -1) {
            AL.alSourcePause(this.sourceID);
        }
        this.isPlaying = false;
    }

    @Override
    public boolean isPlaying() {
        if (this.audio.noDevice) {
            return false;
        }
        if (this.sourceID == -1) {
            return false;
        }
        return this.isPlaying;
    }

    @Override
    public boolean isLooping() {
        return this.isLooping;
    }

    @Override
    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float volume) {
        this.volume = volume;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID != -1) {
            AL.alSourcef(this.sourceID, 4106, volume);
        }
    }

    @Override
    public void setPan(float pan, float volume) {
        this.volume = volume;
        this.pan = pan;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        AL.alSource3f(this.sourceID, 4100, Mathf.cos((pan - 1.0f) * (float)Math.PI / 2.0f), 0.0f, Mathf.sin((pan + 1.0f) * (float)Math.PI / 2.0f));
        AL.alSourcef(this.sourceID, 4106, volume);
    }

    @Override
    public float getPosition() {
        if (this.audio.noDevice) {
            return 0.0f;
        }
        if (this.sourceID == -1) {
            return 0.0f;
        }
        return this.renderedSeconds + AL.alGetSourcef(this.sourceID, 4132);
    }

    @Override
    public void setPosition(float position) {
        int bufferID;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        boolean wasPlaying = this.isPlaying;
        this.isPlaying = false;
        AL.alSourceStop(this.sourceID);
        AL.alSourceUnqueueBuffers(this.sourceID, this.buffers);
        while (this.renderedSecondsQueue.size > 0) {
            this.renderedSeconds = this.renderedSecondsQueue.pop();
        }
        if (position <= this.renderedSeconds) {
            this.reset();
            this.renderedSeconds = 0.0f;
        }
        while (this.renderedSeconds < position - this.maxSecondsPerBuffer && this.read(tempBytes) > 0) {
            this.renderedSeconds += this.maxSecondsPerBuffer;
        }
        this.renderedSecondsQueue.add(this.renderedSeconds);
        boolean filled = false;
        for (int i = 0; i < 3 && this.fill(bufferID = this.buffers.get(i)); ++i) {
            filled = true;
            AL.alSourceQueueBuffers(this.sourceID, bufferID);
        }
        this.renderedSecondsQueue.pop();
        if (!filled) {
            this.stop();
            if (this.onCompletionListener != null) {
                this.onCompletionListener.complete(this);
            }
        }
        AL.alSourcef(this.sourceID, 4132, position - this.renderedSeconds);
        if (wasPlaying) {
            AL.alSourcePlay(this.sourceID);
            this.isPlaying = true;
        }
    }

    public abstract int read(byte[] var1);

    public abstract void reset();

    protected void loop() {
        this.reset();
    }

    public int getChannels() {
        return this.format == 4355 ? 2 : 1;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public void update() {
        int bufferID;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        boolean end = false;
        int buffers = AL.alGetSourcei(this.sourceID, 4118);
        while (buffers-- > 0 && (bufferID = AL.alSourceUnqueueBuffers(this.sourceID)) != 40963) {
            if (this.renderedSecondsQueue.size > 0) {
                this.renderedSeconds = this.renderedSecondsQueue.pop();
            }
            if (end) continue;
            if (this.fill(bufferID)) {
                AL.alSourceQueueBuffers(this.sourceID, bufferID);
                continue;
            }
            end = true;
        }
        if (end && AL.alGetSourcei(this.sourceID, 4117) == 0) {
            this.stop();
            if (this.onCompletionListener != null) {
                this.onCompletionListener.complete(this);
            }
        }
        if (this.isPlaying && AL.alGetSourcei(this.sourceID, 4112) != 4114) {
            AL.alSourcePlay(this.sourceID);
        }
    }

    private boolean fill(int bufferID) {
        tempBuffer.clear();
        int length = this.read(tempBytes);
        if (length <= 0) {
            if (this.isLooping) {
                this.loop();
                length = this.read(tempBytes);
                if (length <= 0) {
                    return false;
                }
                if (this.renderedSecondsQueue.size > 0) {
                    this.renderedSecondsQueue.set(0, 0.0f);
                }
            } else {
                return false;
            }
        }
        float previousLoadedSeconds = this.renderedSecondsQueue.size > 0 ? this.renderedSecondsQueue.first() : 0.0f;
        float currentBufferSeconds = this.maxSecondsPerBuffer * (float)length / 40960.0f;
        this.renderedSecondsQueue.insert(0, previousLoadedSeconds + currentBufferSeconds);
        tempBuffer.put(tempBytes, 0, length).flip();
        AL.alBufferData(bufferID, this.format, tempBuffer, tempBuffer.remaining(), this.sampleRate);
        return true;
    }

    @Override
    public void dispose() {
        this.stop();
        if (this.audio.noDevice) {
            return;
        }
        if (this.buffers == null) {
            return;
        }
        AL.alDeleteBuffers(this.buffers);
        this.buffers = null;
        this.onCompletionListener = null;
    }

    @Override
    public void setCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    public int getSourceId() {
        return this.sourceID;
    }
}

