/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl.audio;

import io.anuke.arc.Audio;
import io.anuke.arc.audio.AudioDevice;
import io.anuke.arc.audio.AudioRecorder;
import io.anuke.arc.audio.mock.MockAudioDevice;
import io.anuke.arc.audio.mock.MockAudioRecorder;
import io.anuke.arc.backends.sdl.audio.ALMusic;
import io.anuke.arc.backends.sdl.audio.ALSound;
import io.anuke.arc.backends.sdl.audio.Mp3;
import io.anuke.arc.backends.sdl.audio.Ogg;
import io.anuke.arc.backends.sdl.audio.Wav;
import io.anuke.arc.backends.sdl.jni.AL;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntArray;
import io.anuke.arc.collection.IntIntMap;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.ArcRuntimeException;
import io.anuke.arc.util.BufferUtils;
import java.nio.FloatBuffer;

public class ALAudio
extends Audio {
    Array<ALMusic> music = new Array(false, 1, ALMusic.class);
    long device;
    long context;
    boolean noDevice = false;
    private IntArray idleSources;
    private IntArray allSources;
    private IntIntMap soundIdToSource;
    private IntIntMap sourceToSoundId;
    private int nextSoundId = 0;
    private ObjectMap<String, SoundConstructor> soundTypes = new ObjectMap();
    private ObjectMap<String, MusicConstructor> musicTypes = new ObjectMap();
    private ALSound[] recentSounds;
    private int mostRecetSound = -1;

    public ALAudio(int simultaneousSources) {
        this.soundTypes.put("ogg", Ogg.Sound::new);
        this.musicTypes.put("ogg", Ogg.Music::new);
        this.soundTypes.put("wav", Wav.Sound::new);
        this.musicTypes.put("wav", Wav.Music::new);
        this.soundTypes.put("mp3", Mp3.Sound::new);
        this.musicTypes.put("mp3", Mp3.Music::new);
        this.device = AL.alcOpenDevice();
        if (this.device == 0L) {
            this.noDevice = true;
            this.checkError();
            return;
        }
        this.context = AL.alcCreateContext(this.device, null);
        if (this.context == 0L) {
            AL.alcCloseDevice(this.device);
            this.noDevice = true;
            this.checkError();
            return;
        }
        if (!AL.alcMakeContextCurrent(this.context)) {
            this.noDevice = true;
            this.checkError();
            return;
        }
        this.allSources = new IntArray(false, simultaneousSources);
        for (int i = 0; i < simultaneousSources; ++i) {
            int sourceID = AL.alGenSources();
            if (AL.alGetError() != 0) break;
            this.allSources.add(sourceID);
        }
        this.idleSources = new IntArray(this.allSources);
        this.soundIdToSource = new IntIntMap();
        this.sourceToSoundId = new IntIntMap();
        FloatBuffer orientation = (FloatBuffer)BufferUtils.newFloatBuffer(6).put(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f}).flip();
        AL.alListenerfv(4111, orientation);
        FloatBuffer velocity = (FloatBuffer)BufferUtils.newFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f}).flip();
        AL.alListenerfv(4102, velocity);
        FloatBuffer position = (FloatBuffer)BufferUtils.newFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f}).flip();
        AL.alListenerfv(4100, position);
        this.recentSounds = new ALSound[simultaneousSources];
    }

    void checkError() {
        int error = AL.alGetError();
        if (error != 0) {
            throw new ArcRuntimeException("AL Initialization error, code: " + error);
        }
    }

    @Override
    public ALSound newSound(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        SoundConstructor soundClass = this.soundTypes.get(file.extension().toLowerCase());
        if (soundClass == null) {
            throw new ArcRuntimeException("Unknown file extension for sound: " + file);
        }
        return soundClass.make(this, file);
    }

    @Override
    public ALMusic newMusic(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        MusicConstructor musicClass = this.musicTypes.get(file.extension().toLowerCase());
        if (musicClass == null) {
            throw new ArcRuntimeException("Unknown file extension for music: " + file);
        }
        return musicClass.make(this, file);
    }

    int obtainSource(boolean isMusic) {
        if (this.noDevice) {
            return 0;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceId = this.idleSources.get(i);
            int state = AL.alGetSourcei(sourceId, 4112);
            if (state == 4114 || state == 4115) continue;
            if (isMusic) {
                this.idleSources.removeIndex(i);
            } else {
                int soundId;
                if (this.sourceToSoundId.containsKey(sourceId)) {
                    soundId = this.sourceToSoundId.get(sourceId, 0);
                    this.sourceToSoundId.remove(sourceId, 0);
                    this.soundIdToSource.remove(soundId, 0);
                }
                soundId = this.nextSoundId++;
                this.sourceToSoundId.put(sourceId, soundId);
                this.soundIdToSource.put(soundId, sourceId);
            }
            AL.alSourceStop(sourceId);
            AL.alSourcei(sourceId, 4105, 0);
            AL.alSourcef(sourceId, 4106, 1.0f);
            AL.alSourcef(sourceId, 4099, 1.0f);
            AL.alSource3f(sourceId, 4100, 0.0f, 0.0f, 1.0f);
            return sourceId;
        }
        return -1;
    }

    void freeSource(int sourceID) {
        if (this.noDevice) {
            return;
        }
        AL.alSourceStop(sourceID);
        AL.alSourcei(sourceID, 4105, 0);
        if (this.sourceToSoundId.containsKey(sourceID)) {
            int soundId = this.sourceToSoundId.remove(sourceID, 0);
            this.soundIdToSource.remove(soundId, 0);
        }
        this.idleSources.add(sourceID);
    }

    void freeBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL.alGetSourcei(sourceID, 4105) != bufferID) continue;
            if (this.sourceToSoundId.containsKey(sourceID)) {
                int soundId = this.sourceToSoundId.remove(sourceID, 0);
                this.soundIdToSource.remove(soundId, 0);
            }
            AL.alSourceStop(sourceID);
            AL.alSourcei(sourceID, 4105, 0);
        }
    }

    void stopSourcesWithBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL.alGetSourcei(sourceID, 4105) != bufferID) continue;
            if (this.sourceToSoundId.containsKey(sourceID)) {
                int soundId = this.sourceToSoundId.remove(sourceID, 0);
                this.soundIdToSource.remove(soundId, 0);
            }
            AL.alSourceStop(sourceID);
        }
    }

    void pauseSourcesWithBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL.alGetSourcei(sourceID, 4105) != bufferID) continue;
            AL.alSourcePause(sourceID);
        }
    }

    void resumeSourcesWithBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL.alGetSourcei(sourceID, 4105) != bufferID || AL.alGetSourcei(sourceID, 4112) != 4115) continue;
            AL.alSourcePlay(sourceID);
        }
    }

    public void update() {
        if (this.noDevice) {
            return;
        }
        for (int i = 0; i < this.music.size; ++i) {
            ((ALMusic[])this.music.items)[i].update();
        }
    }

    public int getSoundId(int sourceId) {
        if (!this.sourceToSoundId.containsKey(sourceId)) {
            return -1;
        }
        return this.sourceToSoundId.get(sourceId, 0);
    }

    public void stopSound(int soundId) {
        if (!this.soundIdToSource.containsKey(soundId)) {
            return;
        }
        int sourceId = this.soundIdToSource.get(soundId, 0);
        AL.alSourceStop(sourceId);
    }

    public void pauseSound(int soundId) {
        if (!this.soundIdToSource.containsKey(soundId)) {
            return;
        }
        int sourceId = this.soundIdToSource.get(soundId, 0);
        AL.alSourcePause(sourceId);
    }

    public void resumeSound(int soundId) {
        if (!this.soundIdToSource.containsKey(soundId)) {
            return;
        }
        int sourceId = this.soundIdToSource.get(soundId, 0);
        if (AL.alGetSourcei(sourceId, 4112) == 4115) {
            AL.alSourcePlay(sourceId);
        }
    }

    public void setSoundGain(int soundId, float volume) {
        if (!this.soundIdToSource.containsKey(soundId)) {
            return;
        }
        int sourceId = this.soundIdToSource.get(soundId, 0);
        AL.alSourcef(sourceId, 4106, volume);
    }

    public void setSoundLooping(int soundId, boolean looping) {
        if (!this.soundIdToSource.containsKey(soundId)) {
            return;
        }
        int sourceId = this.soundIdToSource.get(soundId, 0);
        AL.alSourcei(sourceId, 4103, looping ? 1 : 0);
    }

    public void setSoundPitch(int soundId, float pitch) {
        if (!this.soundIdToSource.containsKey(soundId)) {
            return;
        }
        int sourceId = this.soundIdToSource.get(soundId, 0);
        AL.alSourcef(sourceId, 4099, pitch);
    }

    public void setSoundPan(int soundId, float pan, float volume) {
        if (!this.soundIdToSource.containsKey(soundId)) {
            return;
        }
        int sourceId = this.soundIdToSource.get(soundId, 0);
        AL.alSource3f(sourceId, 4100, Mathf.cos((pan - 1.0f) * (float)Math.PI / 2.0f), 0.0f, Mathf.sin((pan + 1.0f) * (float)Math.PI / 2.0f));
        AL.alSourcef(sourceId, 4106, volume);
    }

    @Override
    public void dispose() {
        if (this.noDevice) {
            return;
        }
        int n = this.allSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.allSources.get(i);
            int state = AL.alGetSourcei(sourceID, 4112);
            if (state != 4116) {
                AL.alSourceStop(sourceID);
            }
            AL.alDeleteSources(sourceID);
        }
        this.sourceToSoundId.clear();
        this.soundIdToSource.clear();
        AL.alcDestroyContext(this.context);
        AL.alcCloseDevice(this.device);
    }

    @Override
    public AudioDevice newAudioDevice(int sampleRate, boolean isMono) {
        return new MockAudioDevice();
    }

    @Override
    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        return new MockAudioRecorder();
    }

    protected void retain(ALSound sound, boolean stop) {
        ++this.mostRecetSound;
        this.mostRecetSound %= this.recentSounds.length;
        if (stop && this.recentSounds[this.mostRecetSound] != null) {
            this.recentSounds[this.mostRecetSound].stop();
        }
        this.recentSounds[this.mostRecetSound] = sound;
    }

    public void forget(ALSound sound) {
        for (int i = 0; i < this.recentSounds.length; ++i) {
            if (this.recentSounds[i] != sound) continue;
            this.recentSounds[i] = null;
        }
    }

    public static interface MusicConstructor {
        public ALMusic make(ALAudio var1, FileHandle var2);
    }

    public static interface SoundConstructor {
        public ALSound make(ALAudio var1, FileHandle var2);
    }
}

