/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.backends.sdl;

import io.anuke.arc.Application;
import io.anuke.arc.Core;
import io.anuke.arc.Graphics;
import io.anuke.arc.backends.sdl.SdlApplication;
import io.anuke.arc.backends.sdl.SdlGL20;
import io.anuke.arc.backends.sdl.jni.SDL;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.graphics.GL20;
import io.anuke.arc.graphics.GL30;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.glutils.GLVersion;
import io.anuke.arc.graphics.glutils.HdpiMode;
import io.anuke.arc.util.ArcRuntimeException;

public class SdlGraphics
extends Graphics {
    private GL20 gl20;
    private GLVersion glVersion;
    private Graphics.BufferFormat bufferFormat;
    private SdlApplication app;
    private ObjectMap<Graphics.Cursor.SystemCursor, SdlCursor> cursors;
    private long lastFrameTime = -1L;
    private float deltaTime;
    private long frameId;
    private long frameCounterStart = 0L;
    private int frames;
    private int fps;
    int backBufferWidth;
    int backBufferHeight;
    int logicalWidth;
    int logicalHeight;

    SdlGraphics(SdlApplication app) {
        this.app = app;
        Core.gl20 = this.gl20 = new SdlGL20();
        Core.gl = this.gl20;
        String versionString = this.gl20.glGetString(7938);
        String vendorString = this.gl20.glGetString(7936);
        String rendererString = this.gl20.glGetString(7937);
        this.cursors = new ObjectMap();
        this.glVersion = new GLVersion(Application.ApplicationType.Desktop, versionString, vendorString, rendererString);
        this.bufferFormat = new Graphics.BufferFormat(app.config.r, app.config.g, app.config.b, app.config.a, app.config.depth, app.config.stencil, app.config.samples, false);
        if (!this.glVersion.isVersionEqualToOrHigher(2, 0) || !this.supportsFBO()) {
            throw new ArcRuntimeException("OpenGL 2.0 or higher with the FBO extension is required. OpenGL version: " + versionString);
        }
        this.clear(app.config.initialBackgroundColor);
        SDL.SDL_GL_SwapWindow(app.window);
    }

    boolean supportsFBO() {
        return this.glVersion.isVersionEqualToOrHigher(3, 0) || SDL.SDL_GL_ExtensionSupported("GL_EXT_framebuffer_object") || SDL.SDL_GL_ExtensionSupported("GL_ARB_framebuffer_object");
    }

    void update() {
        long time = System.nanoTime();
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = time;
        }
        this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        this.lastFrameTime = time;
        if (time - this.frameCounterStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameCounterStart = time;
        }
        ++this.frames;
        ++this.frameId;
    }

    void updateSize(int width, int height) {
        this.logicalWidth = width;
        this.logicalHeight = height;
        this.backBufferWidth = width;
        this.backBufferHeight = height;
        this.gl20.glViewport(0, 0, width, height);
    }

    @Override
    public boolean isGL30Available() {
        return false;
    }

    @Override
    public GL20 getGL20() {
        return this.gl20;
    }

    @Override
    public void setGL20(GL20 gl20) {
        this.gl20 = gl20;
    }

    @Override
    public GL30 getGL30() {
        return null;
    }

    @Override
    public void setGL30(GL30 gl30) {
    }

    @Override
    public int getWidth() {
        if (this.app.config.hdpiMode == HdpiMode.Pixels) {
            return this.backBufferWidth;
        }
        return this.logicalWidth;
    }

    @Override
    public int getHeight() {
        if (this.app.config.hdpiMode == HdpiMode.Pixels) {
            return this.backBufferHeight;
        }
        return this.logicalHeight;
    }

    @Override
    public int getBackBufferWidth() {
        return this.backBufferWidth;
    }

    @Override
    public int getBackBufferHeight() {
        return this.backBufferHeight;
    }

    @Override
    public long getFrameId() {
        return this.frameId;
    }

    @Override
    public float getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    @Override
    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    @Override
    public float getPpiX() {
        return 0.0f;
    }

    @Override
    public float getPpiY() {
        return 0.0f;
    }

    @Override
    public float getPpcX() {
        return 0.0f;
    }

    @Override
    public float getPpcY() {
        return 0.0f;
    }

    @Override
    public float getDensity() {
        return 0.0f;
    }

    @Override
    public boolean supportsDisplayModeChange() {
        return true;
    }

    @Override
    public Graphics.Monitor getPrimaryMonitor() {
        return this.getMonitor();
    }

    @Override
    public Graphics.Monitor getMonitor() {
        return new Graphics.Monitor(0, 0, "Monitor");
    }

    @Override
    public Graphics.Monitor[] getMonitors() {
        return new Graphics.Monitor[0];
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[0];
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return new Graphics.DisplayMode[0];
    }

    @Override
    public Graphics.DisplayMode getDisplayMode() {
        return new Graphics.DisplayMode(this.getWidth(), this.getHeight(), 60, 32);
    }

    @Override
    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return this.getDisplayMode();
    }

    @Override
    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        SDL.SDL_SetWindowFullscreen(this.app.window, 4097);
        return true;
    }

    @Override
    public boolean setWindowedMode(int width, int height) {
        SDL.SDL_SetWindowFullscreen(this.app.window, 0);
        SDL.SDL_SetWindowSize(this.app.window, width, height);
        return true;
    }

    @Override
    public void setTitle(String title) {
        SDL.SDL_SetWindowTitle(this.app.window, title);
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        boolean maximized;
        boolean bl = maximized = (SDL.SDL_GetWindowFlags(this.app.window) & 0x80) == 128;
        if (maximized) {
            SDL.SDL_RestoreWindow(this.app.window);
        }
        SDL.SDL_SetWindowBordered(this.app.window, !undecorated);
        if (maximized) {
            SDL.SDL_MaximizeWindow(this.app.window);
        }
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    public void setVSync(boolean vsync) {
        SDL.SDL_GL_SetSwapInterval(vsync ? 1 : 0);
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return SDL.SDL_GL_ExtensionSupported(extension);
    }

    @Override
    public boolean isContinuousRendering() {
        return false;
    }

    @Override
    public void setContinuousRendering(boolean isContinuous) {
    }

    @Override
    public void requestRendering() {
    }

    @Override
    public boolean isFullscreen() {
        return (SDL.SDL_GetWindowFlags(this.app.window) & 1) == 1;
    }

    @Override
    public Graphics.Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        long surface = SDL.SDL_CreateRGBSurfaceFrom(pixmap.getPixels(), pixmap.getWidth(), pixmap.getHeight());
        long cursor = SDL.SDL_CreateColorCursor(surface, xHotspot, yHotspot);
        return new SdlCursor(surface, cursor);
    }

    @Override
    protected void setCursor(Graphics.Cursor cursor) {
        SDL.SDL_SetCursor(((SdlCursor)cursor).cursorHandle);
    }

    @Override
    protected void setSystemCursor(Graphics.Cursor.SystemCursor cursor) {
        if (!this.cursors.containsKey(cursor)) {
            long handle = SDL.SDL_CreateSystemCursor(this.mapCursor(cursor));
            this.cursors.put(cursor, new SdlCursor(0L, handle));
        }
        SDL.SDL_SetCursor(this.cursors.get((Graphics.Cursor.SystemCursor)cursor).cursorHandle);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cursors.each((ignored, value) -> value.dispose());
    }

    private int mapCursor(Graphics.Cursor.SystemCursor cursor) {
        switch (cursor) {
            case arrow: {
                return SDL.SDL_SYSTEM_CURSOR_ARROW;
            }
            case ibeam: {
                return SDL.SDL_SYSTEM_CURSOR_IBEAM;
            }
            case crosshair: {
                return SDL.SDL_SYSTEM_CURSOR_CROSSHAIR;
            }
            case hand: {
                return SDL.SDL_SYSTEM_CURSOR_HAND;
            }
            case horizontalResize: {
                return SDL.SDL_SYSTEM_CURSOR_SIZEWE;
            }
            case verticalResize: {
                return SDL.SDL_SYSTEM_CURSOR_SIZENS;
            }
        }
        throw new IllegalArgumentException("this is impossible.");
    }

    public static class SdlCursor
    implements Graphics.Cursor {
        final long surfaceHandle;
        final long cursorHandle;

        public SdlCursor(long surfaceHandle, long cursorHandle) {
            this.surfaceHandle = surfaceHandle;
            this.cursorHandle = cursorHandle;
        }

        @Override
        public void dispose() {
            if (this.cursorHandle != 0L) {
                SDL.SDL_FreeCursor(this.cursorHandle);
            }
            if (this.surfaceHandle != 0L) {
                SDL.SDL_FreeSurface(this.surfaceHandle);
            }
        }
    }
}

