/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc.assets.loaders;

import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.assets.AssetLoaderParameters;
import io.anuke.arc.assets.AssetManager;
import io.anuke.arc.assets.loaders.FileHandleResolver;
import io.anuke.arc.assets.loaders.SynchronousAssetLoader;
import io.anuke.arc.assets.loaders.TextureLoader;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.TextureAtlas;

public class TextureAtlasLoader
extends SynchronousAssetLoader<TextureAtlas, TextureAtlasParameter> {
    TextureAtlas.TextureAtlasData data;

    public TextureAtlasLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public TextureAtlas load(AssetManager assetManager, String fileName, FileHandle file, TextureAtlasParameter parameter) {
        for (TextureAtlas.TextureAtlasData.Page page : this.data.getPages()) {
            page.texture = assetManager.get(page.textureFile.path().replaceAll("\\\\", "/"), Texture.class);
        }
        TextureAtlas atlas = new TextureAtlas(this.data);
        this.data = null;
        return atlas;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle atlasFile, TextureAtlasParameter parameter) {
        FileHandle imgDir = atlasFile.parent();
        this.data = parameter != null ? new TextureAtlas.TextureAtlasData(atlasFile, imgDir, parameter.flip) : new TextureAtlas.TextureAtlasData(atlasFile, imgDir, false);
        Array<AssetDescriptor> dependencies = new Array<AssetDescriptor>();
        for (TextureAtlas.TextureAtlasData.Page page : this.data.getPages()) {
            TextureLoader.TextureParameter params = new TextureLoader.TextureParameter();
            params.format = page.format;
            params.genMipMaps = page.useMipMaps;
            params.minFilter = page.minFilter;
            params.magFilter = page.magFilter;
            dependencies.add(new AssetDescriptor<Texture>(page.textureFile, Texture.class, params));
        }
        return dependencies;
    }

    public static class TextureAtlasParameter
    extends AssetLoaderParameters<TextureAtlas> {
        public boolean flip = false;

        public TextureAtlasParameter() {
        }

        public TextureAtlasParameter(boolean flip) {
            this.flip = flip;
        }

        public TextureAtlasParameter(AssetLoaderParameters.LoadedCallback loadedCallback) {
            super(loadedCallback);
        }
    }
}

