/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.arc;

import io.anuke.arc.ApplicationListener;
import io.anuke.arc.files.FileHandle;

public abstract class ApplicationCore
implements ApplicationListener {
    protected ApplicationListener[] modules = new ApplicationListener[0];

    public void add(ApplicationListener module) {
        ApplicationListener[] news = new ApplicationListener[this.modules.length + 1];
        news[news.length - 1] = module;
        System.arraycopy(this.modules, 0, news, 0, this.modules.length);
        this.modules = news;
    }

    public abstract void setup();

    @Override
    public void init() {
        this.setup();
        for (ApplicationListener listener : this.modules) {
            listener.init();
        }
    }

    @Override
    public void resize(int width, int height) {
        for (ApplicationListener listener : this.modules) {
            listener.resize(width, height);
        }
    }

    @Override
    public void update() {
        for (ApplicationListener listener : this.modules) {
            listener.update();
        }
    }

    @Override
    public void pause() {
        for (ApplicationListener listener : this.modules) {
            listener.pause();
        }
    }

    @Override
    public void resume() {
        for (ApplicationListener listener : this.modules) {
            listener.resume();
        }
    }

    @Override
    public void dispose() {
        for (ApplicationListener listener : this.modules) {
            listener.dispose();
        }
    }

    @Override
    public void fileDropped(FileHandle file) {
        for (ApplicationListener listener : this.modules) {
            listener.fileDropped(file);
        }
    }
}

