/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ew8.labelpainter.sdkdemo;

import com.ew8.labelpainter.sdk.LPSDK;
import java.awt.Color;

/**
 *
 * @author lyz
 */
public class TestDemo {

    public static void main(String[] args) {
        String docFile = "d:\\demo.zhl";
        String labelImg = "d:\\demo.png";
        String outputPdf = "d:\\outputDemo.pdf";
        String outputPdfCustom = "d:\\outputCustomDemo.pdf";
        String overlayPdf = "d:\\overlayDemo.pdf";
        String demoText = "   中琅条码标签打印软件(LabelPainter)是一款强大、专业、易用的条码生成工具、二维码生成器、标签制作软件、批量打印工具。她适用于：防伪标签、物流标签、商品标签、超市价签、医药标签、珠宝标签、吊牌证卡等的设计制作及批量打印工作。\n   中琅条码生成软件不仅仅支持普通的条码打印机、喷墨打印机、激光打印机，还支持各类数码印刷设备。软件支持RGB、CMYK(含专色)、HSL、HSV等颜色模式，及PDF矢量图导入、一键输出PDF文档等。";
        int barcode1d, barcode2d, singleLineText, multiLineText, rect;
        int pageCount = 10;
        int rt;

        /////////////////////////////////////////////////////////////////
        ///                        常规操作示例                    ///////
        /////////////////////////////////////////////////////////////////   
        //新建文档
        rt = LPSDK.createDoc(60, 30);
        if (rt != LPSDK.RET_OK) {
            System.out.println("创建文档失败");
        };

        //设置布局
        rt = LPSDK.setLayout(0, 0, 0, 0, 1, 1, -1, -1, -1, -1, 1);
        if (rt != LPSDK.RET_OK) {
            System.out.println("设置布局失败");
        };

        //插入二维码
        barcode2d = LPSDK.insertBarcode(1.6, 1.9, 16.1, 16.1, "http://www.tiaomaruanjian.com/", "", 58, 6, 0, false, false, Color.black.getRGB(), Color.white.getRGB(), "", 0, 0, 0, 0, 0, 0);
        if (barcode2d < 1) {
            System.out.println("图形插入失败");
        }

        //插入多边形
        rect = LPSDK.insertPolygon(new double[]{0.8, 18.5, 18.5, 0.8}, new double[]{19.3, 19.3, 22.2, 22.2}, 0.2, 1, Color.gray.getRGB(), Color.white.getRGB(), 0);
        if (rect < 1) {
            System.out.println("图形插入失败");
        }

        //插入单行文本
        singleLineText = LPSDK.insertText(1.2, 18.9, 16.7, 3.3, "中琅条码标签打印软件", 0, false, "微软雅黑", 6, 0, Color.red.getRGB(), 0, 0.1, 0, 0);
        if (singleLineText < 1) {
            System.out.println("图形插入失败");
        }

        //插入多行文本
        multiLineText = LPSDK.insertText(19.8, 1.0, 38.9, 28.2, demoText, 1, false, "宋体", 5, 0, Color.black.getRGB(), 0, 0.1, 0.6, 0);
        if (multiLineText < 1) {
            System.out.println("图形插入失败");
        }

        //保存标签图片
        rt = LPSDK.saveLabelImage(labelImg);
        if (rt != LPSDK.RET_OK) {
            System.out.println("标签图片生成失败");
        }

        //输出
        LPSDK.outputToPDF(outputPdf, false, "", 0, 1, 10, false);
        if (rt != LPSDK.RET_OK) {
            System.out.println("输出文档失败");
        }

        //保存文档
        rt = LPSDK.saveDoc(docFile);
        if (rt != LPSDK.RET_OK) {
            System.out.println("保存文档失败");
        };

        //关闭文档
        rt = LPSDK.closeDoc();
        if (rt != LPSDK.RET_OK) {
            System.out.println("关闭文档失败");
        }

        /////////////////////////////////////////////////////////////////
        ///                        自定义输出示例                  ///////
        /////////////////////////////////////////////////////////////////        
        //打开文档
        rt = LPSDK.openDoc(docFile, "");
        if (rt != LPSDK.RET_OK) {
            System.out.println("打开文档失败");
        };

        //插入条形码
        barcode1d = LPSDK.insertBarcode(1.0, 23.3, 17, 5.3, "123456", "??? ???", 20, 6, 0, false, false, Color.black.getRGB(), Color.white.getRGB(), "微软雅黑", 6, 0, Color.blue.getRGB(), 1, 0, 0);
        if (barcode1d < 1) {
            System.out.println("图形插入失败");
        }

        //删除图形
        rt = LPSDK.deleteShape(rect);
        if (rt != LPSDK.RET_OK) {
            System.out.println("删除图形失败");
        }
        rt = LPSDK.deleteShape(multiLineText);
        if (rt != LPSDK.RET_OK) {
            System.out.println("删除图形失败");
        }
        rt = LPSDK.deleteShape(singleLineText);
        if (rt != LPSDK.RET_OK) {
            System.out.println("删除图形失败");
        }
        rt = LPSDK.deleteShape(barcode2d);
        if (rt != LPSDK.RET_OK) {
            System.out.println("删除图形失败");
        }

        //自定义输出
        rt = LPSDK.outputToPDF(outputPdfCustom, false, "", 0, 1, 10, true);
        if (rt != LPSDK.RET_OK) {
            System.out.println("自定义输出失败");
        } else {
            //单页赋值并输出
            for (int i = 1; i <= pageCount; i++) {
                //图形赋值
                if (!setShapeData(barcode1d, String.format("%06d", i))) {
                    System.out.println("图形赋值失败");
                    break;
                }

                //输出当前页
                rt = LPSDK.startOutputCustom();
                if (rt != LPSDK.RET_OK) {
                    System.out.println("输出当前页失败");
                    break;
                }
            }

            //停止输出
            rt = LPSDK.stopOutput();
            if (rt != LPSDK.RET_OK) {
                System.out.println("停止输出失败");
            }
        }

        //关闭文档
        rt = LPSDK.closeDoc();
        if (rt != LPSDK.RET_OK) {
            System.out.println("关闭文档失败");
        }

        /////////////////////////////////////////////////////////////////
        ///                        PDF工具箱示例                   ///////
        /////////////////////////////////////////////////////////////////
        rt = LPSDK.pdfTool(overlayPdf, outputPdfCustom, outputPdf, 3, true, false, 1);
        if (rt != LPSDK.RET_OK) {
            System.out.println("PDF文档处理失败");
        }

//        System.in.read();
    }

    private static boolean setShapeData(int shapeId, String data) {
        int rt = LPSDK.setDataCustom(shapeId, data);
        while (rt == LPSDK.RET_BUSY) {
            rt = LPSDK.setDataCustom(shapeId, data);
        }
        return rt == LPSDK.RET_OK;
    }
}
