﻿using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Text;

namespace CSharp
{
    public class LabelPainter_SDK_Wrapper
    {
        /// <summary>
        /// SDK File Name
        /// </summary>
        private const string dllName = "../../../../Bin/LabelPainter_SDK.dll";
        
        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_Initialization(string programDir);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_Release();

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_OpenDoc(string filePath, string password);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_CreateDoc(double paperWidth, double paperHeight);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_CloseDoc();

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_SaveDoc(string filePath);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_SetLayout(double marginTop, double marginRight, double marginBottom, double marginLeft, int numberOfRows, int numberOfColumns, double labelWidth, double labelHeight, double labelSpanH, double labelSpanV, int feedDirection);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_SaveLabelImage(string savePath);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_OutputToPrinter(string printer, string txtFile, int startPage, int endPage, bool isCustomOutput);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_OutputToPDF(string savePath, bool useCMYK, string txtFile, int zipLevel, int startPage, int endPage, bool isCustomOutput);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_outputToTIFF(string savePath, string txtFile, int zipLevel, int dpi, int startPage, int endPage, bool isCustomOutput);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_OutputToImage(string saveDir, int extType, int dpi, string txtFile, int startPage, int endPage, bool isCustomOutput);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_StopOutput();

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern bool ZL_IsOutputing();

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern int ZL_InsertLine(double[] pointXs, double[] pointYs, int pointCount, double lineWidth, int lineStyle, int lineColor, int lineType);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern int ZL_InsertPolygon(double[] pointXs, double[] pointYs, int pointCount, double lineWidth, int lineStyle, int lineColor, int fillColor, double angle);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern int ZL_InsertText(double x, double y, double width, double height, string text, int textMode, bool isMirror, string fontName, double fontSize, int fontStyle, int fontColor, int alignment, double wordSpacing, double rowSpacing, double angle);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern int ZL_InsertBarcode(double x, double y, double width, double height, string data, string textFormat, int barcodeType, int codePage, double moduleWidth, bool optimize, bool isMirror, int barColor, int backgroundColor, string fontName, double fontSize, int fontStyle, int fontColor, int alignment, double wordSpacing, double angle);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern int ZL_InsertImage(double x, double y, double width, double height, string imagePath, int scaleType, double angle);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_DeleteShape(int shapeId);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_SetDataCustom(int shapeId, string data);

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_StartOutputCustom();

        [DllImport(dllName, CallingConvention = CallingConvention.StdCall)]
        public static extern eRET ZL_PdfTool(string saveDirOrPath, string file1, string file2, int actionType, bool maximumPages, bool pagePad, int pagesPerBatch);
    }

    public enum eRET
    {
        RET_OK = 0, //无错误
        RET_ERROR = -1, //有错误
        RET_BUSY = -2,	//遇忙，建议稍后重试
    }
}
