/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TabFolder
extends Composite {
    TabItem[] items;
    ImageList imageList;
    static final int TabFolderProc;
    static final TCHAR TabFolderClass;
    static final int ID_UPDOWN = 1;

    static {
        TabFolderClass = new TCHAR(0, "SysTabControl32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, TabFolderClass, wNDCLASS);
        TabFolderProc = wNDCLASS.lpfnWndProc;
        int n2 = OS.GetModuleHandle(null);
        int n3 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n2;
        wNDCLASS.style &= 0xFFFFBFFC;
        int n4 = TabFolderClass.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, TabFolderClass, n4);
        wNDCLASS.lpszClassName = n5;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n3, 0, n5);
    }

    public TabFolder(Composite composite, int n2) {
        super(composite, TabFolder.checkStyle(n2));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(TabFolderProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        if (OS.IsPPC && (n2 & 0x80) == 0) {
            n2 |= 0x400;
        }
        n2 = TabFolder.checkBits(n2, 128, 1024, 0, 0, 0, 0);
        return n2 & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        Point point = super.computeSize(n2, n3, bl2);
        RECT rECT = new RECT();
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0, rECT);
        int n4 = rECT.left - rECT.right;
        int n5 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (n5 != 0) {
            OS.SendMessage(this.handle, 4874, n5 - 1, rECT2);
            n4 = Math.max(n4, rECT2.right - rECT.right);
        }
        RECT rECT3 = new RECT();
        OS.SetRect(rECT3, 0, 0, n4, point.y);
        OS.SendMessage(this.handle, 4904, 1, rECT3);
        int n6 = this.getBorderWidth();
        rECT3.left -= n6;
        rECT3.right += n6;
        n4 = rECT3.right - rECT3.left;
        point.x = Math.max(n4, point.x);
        return point;
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n2, n3, n2 + n4, n3 + n5);
        OS.SendMessage(this.handle, 4904, 1, rECT);
        int n6 = this.getBorderWidth();
        rECT.left -= n6;
        rECT.right += n6;
        rECT.top -= n6;
        rECT.bottom += n6;
        int n7 = rECT.right - rECT.left;
        int n8 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n7, n8);
    }

    void createItem(TabItem tabItem, int n2) {
        TabItem[] tabItemArray;
        int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (n2 < 0 || n2 > n3) {
            this.error(6);
        }
        if (n3 == this.items.length) {
            tabItemArray = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, tabItemArray, 0, this.items.length);
            this.items = tabItemArray;
        }
        if (OS.SendMessage(this.handle, OS.TCM_INSERTITEM, n2, (TCITEM)(tabItemArray = new TCITEM())) == -1) {
            this.error(14);
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, n3 - n2);
        this.items[n2] = tabItem;
        if (n3 == 0) {
            Event event = new Event();
            event.item = this.items[0];
            this.sendEvent(13, event);
        }
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (OS.IsPPC) {
            OS.SendMessage(this.handle, 8199, 524, 0);
        }
        int n2 = OS.SendMessage(this.handle, 4909, 0, 0);
        OS.SendMessage(n2, 1048, 0, Short.MAX_VALUE);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TabItem[4];
    }

    void destroyItem(TabItem tabItem) {
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        int n3 = 0;
        while (n3 < n2) {
            if (this.items[n3] == tabItem) break;
            ++n3;
        }
        if (n3 == n2) {
            return;
        }
        int n4 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (OS.SendMessage(this.handle, 4872, n3, 0) == 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n3 + 1, this.items, n3, --n2 - n3);
        this.items[n2] = null;
        if (n2 == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 4867, 0, 0);
                this.display.releaseImageList(this.imageList);
            }
            this.imageList = null;
            this.items = new TabItem[4];
        }
        if (n2 > 0 && n3 == n4) {
            this.setSelection(Math.max(0, n4 - 1), true);
        }
    }

    void drawThemeBackground(int n2, int n3, RECT rECT) {
        RECT rECT2 = new RECT();
        OS.GetClientRect(this.handle, rECT2);
        OS.MapWindowPoints(this.handle, n3, rECT2, 2);
        if (OS.IntersectRect(new RECT(), rECT2, rECT)) {
            OS.DrawThemeBackground(this.display.hTabTheme(), n2, 10, 0, rECT2, null);
        }
    }

    Control findThemeControl() {
        return this;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        OS.SendMessage(this.handle, 4904, 0, rECT);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public TabItem getItem(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (n2 < 0 || n2 >= n3) {
            this.error(6);
        }
        return this.items[n2];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4868, 0, 0);
    }

    public TabItem[] getItems() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        TabItem[] tabItemArray = new TabItem[n2];
        System.arraycopy(this.items, 0, tabItemArray, 0, n2);
        return tabItemArray;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n2 == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[n2]};
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 4875, 0, 0);
    }

    int imageIndex(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n2 = this.imageList.add(image);
            int n3 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4867, 0, n3);
            return n2;
        }
        int n4 = this.imageList.indexOf(image);
        if (n4 == -1) {
            n4 = this.imageList.add(image);
        } else {
            this.imageList.put(n4, image);
        }
        return n4;
    }

    public int indexOf(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        int n3 = 0;
        while (n3 < n2) {
            if (this.items[n3] == tabItem) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    Point minimumSize(int n2, int n3, boolean bl2) {
        Control[] controlArray = this._getChildren();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < controlArray.length) {
            SerializableCompatibility serializableCompatibility;
            Control control = controlArray[n6];
            int n7 = 0;
            int n8 = OS.SendMessage(this.handle, 4868, 0, 0);
            while (n7 < n8) {
                if (this.items[n7].control == control) break;
                ++n7;
            }
            if (n7 == n8) {
                serializableCompatibility = control.getBounds();
                n4 = Math.max(n4, serializableCompatibility.x + serializableCompatibility.width);
                n5 = Math.max(n5, serializableCompatibility.y + serializableCompatibility.height);
            } else {
                serializableCompatibility = control.computeSize(n2, n3, bl2);
                n4 = Math.max(n4, ((Point)serializableCompatibility).x);
                n5 = Math.max(n5, ((Point)serializableCompatibility).y);
            }
            ++n6;
        }
        return new Point(n4, n5);
    }

    boolean mnemonicHit(char c2) {
        int n2 = 0;
        while (n2 < this.items.length) {
            TabItem tabItem = this.items[n2];
            if (tabItem != null) {
                char c3 = this.findMnemonic(tabItem.getText());
                if (Character.toUpperCase(c2) == Character.toUpperCase(c3) && this.forceFocus()) {
                    if (n2 != this.getSelectionIndex()) {
                        this.setSelection(n2, true);
                    }
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    boolean mnemonicMatch(char c2) {
        int n2 = 0;
        while (n2 < this.items.length) {
            TabItem tabItem = this.items[n2];
            if (tabItem != null) {
                char c3 = this.findMnemonic(tabItem.getText());
                if (Character.toUpperCase(c2) == Character.toUpperCase(c3)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    void releaseChildren(boolean bl2) {
        if (this.items != null) {
            int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
            int n3 = 0;
            while (n3 < n2) {
                TabItem tabItem = this.items[n3];
                if (tabItem != null && !tabItem.isDisposed()) {
                    tabItem.release(false);
                }
                ++n3;
            }
            this.items = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4867, 0, 0);
            this.display.releaseImageList(this.imageList);
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n2 = OS.SendMessage(this.handle, 4868, 0, 0);
        int n3 = 0;
        while (n3 < n2) {
            TabItem tabItem = this.items[n3];
            if (tabItem.control == control) {
                tabItem.setControl(null);
            }
            ++n3;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setSelection(TabItem tabItem) {
        this.checkWidget();
        if (tabItem == null) {
            this.error(4);
        }
        this.setSelection(new TabItem[]{tabItem});
    }

    public void setSelection(TabItem[] tabItemArray) {
        this.checkWidget();
        if (tabItemArray == null) {
            this.error(4);
        }
        if (tabItemArray.length == 0) {
            this.setSelection(-1, false);
        } else {
            int n2 = tabItemArray.length - 1;
            while (n2 >= 0) {
                int n3 = this.indexOf(tabItemArray[n2]);
                if (n3 != -1) {
                    this.setSelection(n3, false);
                }
                --n2;
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        super.setFont(font);
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.sendResize();
            int n2 = OS.SendMessage(this.handle, 4875, 0, 0);
            if (n2 != -1) {
                TabItem tabItem = this.items[n2];
                Control control = tabItem.control;
                if (control != null && !control.isDisposed()) {
                    control.setBounds(this.getClientArea());
                }
            }
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 4868, 0, 0);
        if (n2 < 0 || n2 >= n3) {
            return;
        }
        this.setSelection(n2, false);
    }

    void setSelection(int n2, boolean bl2) {
        Widget widget;
        int n3 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n3 == n2) {
            return;
        }
        if (n3 != -1) {
            TabItem tabItem = this.items[n3];
            widget = tabItem.control;
            if (widget != null && !widget.isDisposed()) {
                widget.setVisible(false);
            }
        }
        OS.SendMessage(this.handle, 4876, n2, 0);
        int n4 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n4 != -1) {
            widget = this.items[n4];
            Control control = ((TabItem)widget).control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (bl2) {
                Event event = new Event();
                event.item = widget;
                this.sendEvent(13, event);
            }
        }
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        int n2 = nMTTDISPINFO.idFrom;
        int n3 = OS.SendMessage(this.handle, 4909, 0, 0);
        if (n3 == nMTTDISPINFO.hwndFrom) {
            TabItem tabItem;
            if (this.toolTipText != null) {
                return "";
            }
            if (n2 >= 0 && n2 < this.items.length && (tabItem = this.items[n2]) != null) {
                return tabItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    boolean traversePage(boolean bl2) {
        int n2 = this.getItemCount();
        if (n2 <= 1) {
            return false;
        }
        int n3 = this.getSelectionIndex();
        if (n3 == -1) {
            n3 = 0;
        } else {
            int n4 = bl2 ? 1 : -1;
            n3 = (n3 + n4 + n2) % n2;
        }
        this.setSelection(n3, true);
        if (n3 == this.getSelectionIndex()) {
            OS.SendMessage(this.handle, 295, 3, 0);
            return true;
        }
        return false;
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x2000000;
        if ((this.style & 0x80000) != 0) {
            n2 |= 0x8000;
        }
        if ((this.style & 0x400) != 0) {
            n2 |= 2;
        }
        return n2 | 0x4000;
    }

    TCHAR windowClass() {
        return TabFolderClass;
    }

    int windowProc() {
        return TabFolderProc;
    }

    LRESULT WM_GETDLGCODE(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8192);
    }

    LRESULT WM_MOUSELEAVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            int n4 = OS.SendMessage(this.handle, 4909, 0, 0);
            if (OS.SendMessage(n4, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0) {
                OS.SendMessage(n4, OS.TTM_DELTOOL, 0, tOOLINFO);
                OS.SendMessage(n4, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
        }
        return lRESULT;
    }

    LRESULT WM_NCHITTEST(int n2, int n3) {
        LRESULT lRESULT = super.WM_NCHITTEST(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = OS.DefWindowProc(this.handle, 132, n2, n3);
        return new LRESULT(n4);
    }

    LRESULT WM_NOTIFY(int n2, int n3) {
        LRESULT lRESULT = super.WM_NOTIFY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PARENTNOTIFY(int n2, int n3) {
        LRESULT lRESULT = super.WM_PARENTNOTIFY(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return lRESULT;
        }
        if ((this.style & 0x4000000) != 0) {
            int n4 = n2 & 0xFFFF;
            switch (n4) {
                case 1: {
                    int n5 = n2 >> 16;
                    int n6 = n3;
                    if (n5 != 1) break;
                    int n7 = OS.GetWindowLong(n6, -20);
                    OS.SetWindowLong(n6, -20, n7 | 0x400000);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (this.isDisposed()) {
            return lRESULT;
        }
        int n4 = OS.SendMessage(this.handle, 4875, 0, 0);
        if (n4 != -1) {
            TabItem tabItem = this.items[n4];
            Control control = tabItem.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
            }
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        int n5 = OS.GetWindowLong(this.handle, -16);
        if ((n5 & 0x200) != 0) {
            OS.InvalidateRect(this.handle, null, true);
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT);
        int n6 = rECT.right - rECT.left;
        int n7 = rECT.bottom - rECT.top;
        OS.GetClientRect(this.handle, rECT);
        int n8 = rECT.right - rECT.left;
        int n9 = rECT.bottom - rECT.top;
        if (n6 == n8 && n7 == n9) {
            return lRESULT;
        }
        RECT rECT2 = new RECT();
        OS.SendMessage(this.handle, 4904, 0, rECT2);
        int n10 = -rECT2.right;
        int n11 = -rECT2.bottom;
        if (n6 != n8) {
            n4 = n8;
            if (n6 < n8) {
                n4 = n6;
            }
            OS.SetRect(rECT, n4 - n10, 0, n6, n7);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n7 != n9) {
            n4 = n9;
            if (n7 < n9) {
                n4 = n7;
            }
            if (n6 < n8) {
                n8 -= n10;
            }
            OS.SetRect(rECT, 0, n4 - n11, n8, n7);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        int n4 = nMHDR.code;
        switch (n4) {
            case -552: 
            case -551: {
                Object object;
                TabItem tabItem = null;
                int n5 = OS.SendMessage(this.handle, 4875, 0, 0);
                if (n5 != -1) {
                    tabItem = this.items[n5];
                }
                if (tabItem != null && (object = tabItem.control) != null && !((Widget)object).isDisposed()) {
                    if (n4 == -551) {
                        ((Control)object).setBounds(this.getClientArea());
                    }
                    ((Control)object).setVisible(n4 == -551);
                }
                if (n4 != -551) break;
                object = new Event();
                ((Event)object).item = tabItem;
                this.postEvent(13, (Event)object);
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }
}

