/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public abstract class ByteArrayTransfer
extends Transfer {
    public TransferData[] getSupportedTypes() {
        int[] nArray = this.getTypeIds();
        TransferData[] transferDataArray = new TransferData[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            transferDataArray[n2] = new TransferData();
            transferDataArray[n2].type = nArray[n2];
            transferDataArray[n2].formatetc = new FORMATETC();
            transferDataArray[n2].formatetc.cfFormat = nArray[n2];
            transferDataArray[n2].formatetc.dwAspect = 1;
            transferDataArray[n2].formatetc.lindex = -1;
            transferDataArray[n2].formatetc.tymed = 1;
            ++n2;
        }
        return transferDataArray;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData == null) {
            return false;
        }
        int[] nArray = this.getTypeIds();
        int n2 = 0;
        while (n2 < nArray.length) {
            FORMATETC fORMATETC = transferData.formatetc;
            if (fORMATETC.cfFormat == nArray[n2] && (fORMATETC.dwAspect & 1) == 1 && (fORMATETC.tymed & 1) == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!this.checkByteArray(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        byte[] byArray = (byte[])object;
        int n2 = byArray.length;
        int n3 = OS.GlobalAlloc(64, n2);
        OS.MoveMemory(n3, byArray, n2);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = n3;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    protected Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0) {
            return null;
        }
        IDataObject iDataObject = new IDataObject(transferData.pIDataObject);
        iDataObject.AddRef();
        FORMATETC fORMATETC = transferData.formatetc;
        STGMEDIUM sTGMEDIUM = new STGMEDIUM();
        sTGMEDIUM.tymed = 1;
        transferData.result = iDataObject.GetData(fORMATETC, sTGMEDIUM);
        iDataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int n2 = sTGMEDIUM.unionField;
        int n3 = OS.GlobalSize(n2);
        byte[] byArray = new byte[n3];
        int n4 = OS.GlobalLock(n2);
        OS.MoveMemory(byArray, n4, n3);
        OS.GlobalUnlock(n2);
        OS.GlobalFree(n2);
        return byArray;
    }

    boolean checkByteArray(Object object) {
        return object != null && object instanceof byte[] && ((byte[])object).length > 0;
    }
}

