float4x3 Bones[NumBones];
float4x4 WorldViewProj;
float3   LightPosition;
float4   LightColor;
float3   ViewPosition;
float4   TexGen[2];

struct vout
{
  float4 position   : POSITION;
  float4 diff       : COLOR0;
  float2 texcoord0  : TEXCOORD0;
};

vout main(float4 position   : POSITION,
          float4 ind        : COLOR0,
          float3 normal     : NORMAL,
          float2 texcoords  : TEXCOORD0)
{
  vout o = (vout)0;

  int index = D3DCOLORtoUBYTE4(ind).x;

  float3 opos = mul(position, Bones[index]);

  normal = normalize(mul(normal, (float3x3)Bones[index]));

  o.position  = mul(float4(opos, 1), WorldViewProj);
  o.texcoord0 = float2(dot(float3(texcoords, 1), TexGen[0].xyz),
                       dot(float3(texcoords, 1), TexGen[1].xyz));

  float3  light   = normalize(LightPosition - opos);
  float   n_dot_l = max(0, dot(normal, light));
 
  o.diff = float4(LightColor.xyz*n_dot_l, 1);

  return o;
}
