float4x3  Bones[NumBones];
float4x4  WorldViewProj;
float4    LightPosition;

struct vout 
{
  float4 position : POSITION;
};

vout main(float4 position   : POSITION,
          float2 texcoords  : TEXCOORD,
          int4   ind        : COLOR0,
          float3 normal     : NORMAL,
          float3 tangent    : TANGENT,
          float3 binormal   : BINORMAL)
{
  vout o = (vout)0;

  int    index = D3DCOLORtoUBYTE4(ind).x;
  float3 opos  = mul(float4(position.xyz, 1), Bones[index]);

  float3 vExtrudeVector = normalize(opos - LightPosition.xyz)*LightPosition.w;

  float4 vResultPosition = float4(vExtrudeVector*(1 - position.w) + opos, 1);
  o.position = mul(vResultPosition, WorldViewProj);
  
  return o;
}
