float4 InvViewportDimensions;

struct vout
{
  float4 pos    : POSITION0;  // +4*4=16
  float2 tex0   : TEXCOORD0;  // +4*2=24
  half4  color  : COLOR0;     // +2*4=32
};

vout main(float4 pos        : POSITION0,  // +4*4=16
	        float4 color      : COLOR0,     // +4*4=32
          float2 texcoords  : TEXCOORD0)  // +4*2=40
{
  vout o;
 
  o.pos    = pos;
  o.pos.xy = ((2*pos.xy - 0.5)*InvViewportDimensions.xy - 1)*float2(1, -1);
  o.tex0   = texcoords;
  o.color  = color;
  
 return o;
}
