float4x3 Bones[NumBones];
float4x4 WorldViewProj;

struct vout 
{
  float4 position   : POSITION;
  float2 texcoords  : TEXCOORD0;
};

vout main(float4 position   : POSITION,
          float4 ind        : COLOR0,
          float2 texcoords  : TEXCOORD0)
{
  vout o = (vout)0;

  int index = D3DCOLORtoUBYTE4(ind).x;
  float3 opos = mul(position, Bones[index]);

  float4 resultPosition = mul(float4(opos.x, opos.y, opos.z, 1.0f), WorldViewProj);

  o.position    = resultPosition;
  o.texcoords.x =  0.5*resultPosition.x/resultPosition.z + 0.5;
  o.texcoords.y = -0.5*resultPosition.y/resultPosition.z + 0.5;
  	
  return o;
}	

