float4x3  Bones[NumBones];
float4x4  WorldViewProj;
float3    LightPosition;
float3    ViewPosition;
float4    TexGen[2];

struct vout
{
  float4 position   : POSITION;   // +4*4=16
  float2 texcoords0 : TEXCOORD0;  // +4*2=24
  float2 texcoords1 : TEXCOORD1;  // +4*2=32
  half3  light      : TEXCOORD2;  // +2*3=38
  half3  halfangle  : TEXCOORD3;  // +2*3=44
};

#define pack(v) (saturate((v)*0.5 + 0.5))

vout main(float4 position   : POSITION,   // +4*4=16
          float4 ind        : COLOR0,     // +4*4=32
          float3 normal     : NORMAL,     // +4*3=44
          float3 tangent    : TANGENT,    // +4*3=56
          float3 binormal   : BINORMAL,   // +4*3=68
          float2 texcoords  : TEXCOORD0)  // +4*2=76
{
  vout o = (vout)0;

  int index   = D3DCOLORtoUBYTE4(ind).x;

  float3 opos = mul(position, Bones[index]);

  tangent     =  normalize(mul(tangent,  (float3x3)Bones[index]));
  binormal    = -normalize(mul(binormal, (float3x3)Bones[index]));
  normal      =  normalize(mul(normal,   (float3x3)Bones[index]));

  o.position   = mul(float4(opos, 1), WorldViewProj);
  o.texcoords0 = float2(dot(float3(texcoords, 1), TexGen[0].xyz),
                        dot(float3(texcoords, 1), TexGen[1].xyz));
  o.texcoords1 = o.texcoords0;

  float3 light  = normalize(LightPosition - opos);
  float3 view   = normalize(ViewPosition  - opos);
  float3 hangle = normalize(light + view);
 
  o.light     = pack(float3(dot(light,  tangent), dot(light,  binormal), dot(light,  normal)));
  o.halfangle = pack(float3(dot(hangle, tangent), dot(hangle, binormal), dot(hangle, normal)));

  return o;
}
