float4x3 Bones[NumBones];
float4x4 WorldViewProj;
float3   LightPosition;
float3   ViewPosition;
float4   TexGen[2];

struct vout
{
  float4 position   : POSITION;
  float2 texcoords  : TEXCOORD0;
  float2 texcoords2 : TEXCOORD1;
  float3 atten      : TEXCOORD2;
  float3 light      : TEXCOORD3;
  float3 bump_atten : COLOR1;
};

#define pack(v) (saturate((v)*0.5 + 0.5))

vout main(float4 position   : POSITION,
          float4 ind        : COLOR0,
          float3 normal     : NORMAL,
          float3 tangent    : TANGENT,
          float3 binormal   : BINORMAL,
          float2 texcoords  : TEXCOORD0)
{
  vout o = (vout)0;

  int index = D3DCOLORtoUBYTE4(ind).x;
  float3 opos = mul(position, Bones[index]);
  
  normal   =  normalize(mul(normal,   (float3x3)Bones[index]));
  tangent  = -normalize(mul(tangent,  (float3x3)Bones[index]));
  binormal =  normalize(mul(binormal, (float3x3)Bones[index]));

  o.position = mul(float4(opos.x, opos.y, opos.z, 1.0), WorldViewProj);

  float2 tex;
  tex.x = dot(float3(texcoords,1) , TexGen[0].xyz);
  tex.y = dot(float3(texcoords,1) , TexGen[1].xyz);

  o.texcoords = o.texcoords2 = tex;

  float3 light = (LightPosition - opos);
  o.atten = light.xyz;
  light   = normalize(light);
 
  float l_dot_n = dot(light, normal);
  o.light = pack(float3(dot(light, tangent), dot(light, binormal), l_dot_n));
  o.bump_atten = 1;

  float c = 0.125;
  float inv_c = 8;

  if (l_dot_n <= c)
    o.bump_atten = l_dot_n*inv_c; 

  return o;
}
