float4x3  Bones[NumBones];
float3    LightPosition;
float4x4  WorldViewProj;

struct vout 
{
  float4 position   : POSITION;
  float2 texcoords  : TEXCOORD0;
  float2 texcoords2 : TEXCOORD1;
  float3 atten      : TEXCOORD2;
  float3 light      : TEXCOORD3;
};

#define pack(v) (saturate((v)*0.5 + 0.5))

vout main(float4 position   : POSITION,
          float4 ind        : COLOR0,
          float3 normal     : NORMAL,
          float3 tangent    : TANGENT,
          float3 binormal   : BINORMAL,
          float2 texcoords  : TEXCOORD0)
{
  vout o = (vout) 0;
 
  int index = D3DCOLORtoUBYTE4(ind).x;
  float3 opos = mul(position, Bones[index]);

  o.position  = mul(float4(opos.x, opos.y, opos.z, 1.0), WorldViewProj);
  o.texcoords = o.texcoords2 = texcoords;
  
  float3 light  = LightPosition - opos;
  o.atten = light.xyz;
   
  light = normalize(light);
  o.light = pack(normalize(float3(dot(light, tangent), -dot(light, binormal), dot(light, normal))));

  return o;
}
