float4x3 Bones[NumBones];
float4x4 WorldViewProj;
float4   TexGen[2];

struct vout 
{
  float4 position  : POSITION;
  float2 texcoords : TEXCOORD0;
};

vout main(float4 position   : POSITION,
          float4 ind        : COLOR0,
          float3 normal     : NORMAL,
          float3 tangent    : TANGENT,
          float3 binormal   : BINORMAL,
          float2 texcoords  : TEXCOORD0)
{
  vout o = (vout) 0;

  int index = D3DCOLORtoUBYTE4(ind).x;
  float3 opos = mul(position, Bones[index]);

  o.position    = mul(float4(opos.x, opos.y, opos.z, 1.0), WorldViewProj);
  o.texcoords.x = dot(float3(texcoords, 1.0), TexGen[0].xyz);
  o.texcoords.y = dot(float3(texcoords, 1.0), TexGen[1].xyz);

  return o;
}
