float4x3  Bones[NumBones];
float4x4  InvWorld;
float4x4  WorldViewProj;
float3    ViewPosition;

struct vout 
{
  float4 position   : POSITION;
  float2 texcoords  : TEXCOORD0;
  float4 row1       : TEXCOORD1;
  float4 row2       : TEXCOORD2;
  float4 row3       : TEXCOORD3;
};

vout main(float4 position   : POSITION,
          float4 ind        : COLOR0,
          float3 normal     : NORMAL,
          float3 tangent    : TANGENT,
          float3 binormal   : BINORMAL,
          float2 texcoords  : TEXCOORD0)
{
  vout o = (vout)0;
 
  int index = D3DCOLORtoUBYTE4(ind).x;
  
  float3 opos = mul(position, Bones[index]);
  float3 bpos = float3(Bones[index][3][0], Bones[index][3][1], Bones[index][3][2]);

  o.position  = mul(float4(opos.x, opos.y, opos.z, position.w), WorldViewProj);
  o.texcoords = texcoords;
  
  float3 vViewer  = bpos + 0.1*(ViewPosition - bpos);
  float3 view     = vViewer - opos;
  float3 inv_view = mul(view, (float3x3)InvWorld);

  tangent  =  normalize(mul(tangent,  (float3x3)Bones[index]));  
  binormal = -normalize(mul(binormal, (float3x3)Bones[index]));
  normal   =  normalize(mul(normal,   (float3x3)Bones[index]));

  float3x3 tan_matr;
  tan_matr = float3x3(tangent, binormal, normal);
  tan_matr = mul(tan_matr, InvWorld);
  tan_matr = transpose(tan_matr);

  o.row1 = float4(tan_matr[0], inv_view.x);
  o.row2 = float4(tan_matr[1], inv_view.y);
  o.row3 = float4(tan_matr[2], inv_view.z);

  return o;
}
