float4x3  Bones[NumBones];
float4x4  WorldViewProj;
float     SystemTime = 0.0;

struct vout 
{
  float4 position   : POSITION;
  float3 texcoords  : TEXCOORD0;
};

vout main(float4 position   : POSITION,
          float4 ind        : COLOR0,
          float2 texcoords  : TEXCOORD0)
{
  vout o = (vout)0;

  int index = D3DCOLORtoUBYTE4(ind).x;
  float3 opos = mul(position, Bones[index]);

  o.position     = mul(float4(opos.x, opos.y, opos.z, 1.0), WorldViewProj);
  o.texcoords.xy = texcoords;
  o.texcoords.z  = SystemTime;
  
  return o;
}	
