@ECHO OFF
REM ##################  RunBackupSet.bat  ######################################
REM # You can use this batch to run any of your backup sets from the           #
REM # command line. Just customize the "User Defined Section" below with your  #
REM # values for your backup action.                                           #
REM ############################################################################

REM ####################  START: User Defined Section  #########################

REM -------------------------------  BACKUP_SET  -------------------------------
REM | The name or ID of the backup set that you want to run.                   |
REM | If backup set name is not in English, please use ID instead.             |
REM | e.g. SET BACKUP_SET="1119083740107"                                      |
REM |  or  SET BACKUP_SET="FileBackupSet-1"                                    |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 backup set.        |
REM ----------------------------------------------------------------------------
SET BACKUP_SET=""

REM -----------------------------  BACKUP_DESTS  -------------------------------
REM | The list of name or ID of the backup destinations that you want to run.  |
REM | If backup destination name is not in English, please use ID instead.     |
REM | e.g. SET BACKUP_DESTS="1740107119083"                                    |
REM |  or  SET BACKUP_DESTS="Destination-1,Destination-2"                      |
REM |  or  SET BACKUP_DESTS="ALL"                                              |
REM |                                                                          |
REM | You can specify multiple destinations in comma-separated format,         |
REM | or use "ALL" to run backup for all destinations.                         |
REM ----------------------------------------------------------------------------
SET BACKUP_DESTS="ALL"

REM -------------------------------  BACKUP_TYPE  ------------------------------
REM | Set backup type. You don't need to change this if you are backing up a   |
REM | file backup set.                                                         |
REM | Options available: FILE/DATABASE/DIFFERENTIAL/LOG                        |
REM | e.g. SET BACKUP_TYPE="FILE"          for file backup                     |
REM |  or  SET BACKUP_TYPE="DATABASE"      for Full database backup            |
REM |  or  SET BACKUP_TYPE="DIFFERENTIAL"  for Differential database backup    |
REM |  or  SET BACKUP_TYPE="LOG"           for Log database backup             |
REM |                                                                          |
REM | For MSExchange 2010 BackupSet                                            |
REM | e.g. SET BACKUP_TYPE="DATABASE"      for Full database backup            |
REM |  or  SET BACKUP_TYPE="DIFFERENTIAL"  for Differential database backup    |
REM |  or  SET BACKUP_TYPE="LOG"           for Incremental database backup     |
REM |  or  SET BACKUP_TYPE="COPY"          for Copy database backup            |
REM ----------------------------------------------------------------------------
SET BACKUP_TYPE="FILE"

REM ------------------------------  SETTING_HOME  ------------------------------
REM | Directory to your setting home. Default to                               |
REM | "C:\Users\USER\.obm" when not set.                                       |
REM | e.g. SET SETTING_HOME="C:\Users\John\.obm"                               |
REM ----------------------------------------------------------------------------
SET SETTING_HOME=""

REM -------------------------------  DELTA_MODE  -------------------------------
REM | Set In-File Delta mode.                                                  |
REM | Options available: Incremental/Differential/Full (I/D/F)                 |
REM | e.g. SET DELTA_MODE="I"   for Incremental In-file delta backup           |
REM |  or  SET DELTA_MODE="D"   for Differential In-file delta backup          |
REM |  or  SET DELTA_MODE="F"   for Full File backup                           |
REM |  or  SET DELTA_MODE=""    for using backup set in-file delta setting     |
REM ----------------------------------------------------------------------------
SET DELTA_MODE=""

REM ------------------------------  CLEANUP_MODE  ------------------------------
REM | You can enable Cleanup mode to remove obsolete files from your backup    |
REM | destinations after backup.                                               |
REM | Options available: ENABLE-CLEANUP/DISABLE-CLEANUP                        |
REM | e.g. SET CLEANUP_MODE="ENABLE-CLEANUP"                                   |
REM |  or  SET CLEANUP_MODE="DISABLE-CLEANUP"                                  |
REM ----------------------------------------------------------------------------
SET CLEANUP_MODE="DISABLE-CLEANUP"

REM -------------------------------  DEBUG_MODE  -------------------------------
REM | Set Debug mode.                                                          |
REM | Options available: ENABLE-DEBUG/DISABLE-DEBUG                            |
REM | e.g. SET DEBUG_MODE="ENABLE-DEBUG"                                       |
REM |  or  SET DEBUG_MODE="DISABLE-DEBUG"                                      |
REM ----------------------------------------------------------------------------
SET DEBUG_MODE="DISABLE-DEBUG"

REM ####################  END: User Defined Section  ###########################

SET APP_HOME=..
SET JAVA_HOME=%APP_HOME%\jvm
SET JAVA_EXE=%JAVA_HOME%\bin\bJW.exe
SET JAVA_LIB_PATH=-Djava.library.path=%APP_HOME%\bin
SET PATH=%JAVA_HOME%\bin;%PATH%
SET CLASSPATH=%APP_HOME%\bin;%APP_HOME%\bin\cb.jar

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
  SET "DEP_LIB_PATH=X86"
  SET JAVA_OPTS=-Xms128m -Xmx768m -XX:MaxDirectMemorySize=512m -Dsun.java2d.noddraw -Dsun.nio.PageAlignDirectMemory=true
) ELSE (
  SET "DEP_LIB_PATH=X64"
  SET JAVA_OPTS=-Xms128m -Xmx2048m -XX:MaxDirectMemorySize=1024m -Dsun.java2d.noddraw -Dsun.nio.PageAlignDirectMemory=true
)
SET PATH=%CD%\%APP_HOME%\bin\%DEP_LIB_PATH%;%PATH%

REM #############################################################################
ECHO - 
ECHO APP_HOME=%APP_HOME%
ECHO SETTING_HOME=%SETTING_HOME%
ECHO JAVA_HOME=%JAVA_HOME%
ECHO JAVA_EXE=%JAVA_EXE%
ECHO JAVA_OPTS=%JAVA_OPTS%
ECHO JAVA_LIB_PATH=%JAVA_LIB_PATH%
ECHO PATH=%PATH%
ECHO CLASSPATH=%CLASSPATH%
ECHO - 

ECHO Running Backup Set - '%BACKUP_SET%' ...
@ECHO ON
%JAVA_EXE% %JAVA_LIB_PATH% -cp %CLASSPATH% %JAVA_OPTS% RunBackupSet %APP_HOME% %BACKUP_SET% %BACKUP_DESTS% %BACKUP_TYPE% %SETTING_HOME% %DELTA_MODE% %CLEANUP_MODE% %DEBUG_MODE%
@ECHO OFF
CD %APP_HOME%
IF "%APP_HOME%"==".." PAUSE
@ECHO ON
