@ECHO OFF
REM ##############################  Restore.bat  ###############################
REM # You can use this batch file to restore backup files using command-line.  #
REM # Just customize the "User Define Section" below with values for your      #
REM # restore action.                                                          #
REM ############################################################################

REM ####################  Start: User Defined Section  #########################

REM -------------------------------  BACKUP_SET  -------------------------------
REM | The name or ID of the backup set that you want to restore.               |
REM | If backup set name is not in English, please use ID instead.             |
REM | e.g. SET BACKUP_SET="1119083740107"                                      |
REM |  or  SET BACKUP_SET="FileBackupSet-1"                                    |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 backup set.        |
REM ----------------------------------------------------------------------------
SET BACKUP_SET=""

REM ------------------------------  DESTINATION  -------------------------------
REM | The name or ID of the backup destination that you want to restore from.  |
REM | If backup destination name is not in English, please use ID instead.     |
REM | e.g. SET DESTINATION="1740107119083"                                     |
REM |  or  SET DESTINATION="Destination-1"                                     |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 destination.       |
REM ----------------------------------------------------------------------------
SET DESTINATION=""

REM -------------------------------  RESTORE_TO  -------------------------------
REM | Directory to where you want files to be restored                         |
REM | Use "\\\\" instead of "\\" when you specify a UNC path                   |
REM | set to "" to restore files to original location                          |
REM | e.g. SET RESTORE_TO="C:\Temp"                                            |
REM ----------------------------------------------------------------------------
SET RESTORE_TO=""

REM ------------------------------  RESTORE_FROM  ------------------------------
REM | File/Directory on the backup server that you would like to restore       |
REM | e.g. SET RESTORE_FROM="C:\Data"                                          |
REM ----------------------------------------------------------------------------
SET RESTORE_FROM=""

REM -----------------------------  POINT_IN_TIME  ------------------------------
REM | The point-in-time snapshot (successful backup) that you want to restore  |
REM | from the backup server. Use "Current" for the latest backup snapshot     |
REM | e.g. SET POINT_IN_TIME="2006-10-04-12-57-13"                             |
REM |  or  SET POINT_IN_TIME="Current"                                         |
REM |                                                                          |
REM | You can retrieve the point in time by using the ListBackupJob.bat        |
REM ----------------------------------------------------------------------------
SET POINT_IN_TIME="Current"

REM ---------------------------  RESTORE_PERMISSION  ---------------------------
REM | set to "Y" if you want to restore file permissions                       |
REM | set to "N" if you do NOT want to restore file permissions                |
REM ----------------------------------------------------------------------------
SET RESTORE_PERMISSION="N"

REM ----------------------------  SKIP_INVALID_KEY  ----------------------------
REM | set to "Y" if you want to skip restore file with invalid key             |
REM | set to "N" if you want to prompt user to input a correct key             |
REM ----------------------------------------------------------------------------
SET SKIP_INVALID_KEY="N"

REM ------------------------------  SYNC_OPTION  -------------------------------
REM | Delete extra files                                                       |
REM | set to "Y" if you want to enable sync option                             |
REM | set to "N" if you do NOT want to enable sync option                      |
REM | set to "" to prompt for selection                                        |
REM ----------------------------------------------------------------------------
SET SYNC_OPTION="N"

REM -------------------------  REPLACE_EXISTING_FILE  --------------------------
REM | set to "--all" to replace all existing file(s) of the same filename      |
REM | set to "--none" to skip all existing file(s) with the same filename      |
REM | set to "" to prompt for selection                                        |
REM ----------------------------------------------------------------------------
SET REPLACE_EXISTING_FILE="--all"

REM ------------------------------  SETTING_HOME  ------------------------------
REM | Directory to your setting home. Default to                               |
REM | "C:\Users\USER\.obm" when not set.                                       |
REM | e.g. SET SETTING_HOME="C:\Users\John\.obm"                               |
REM ----------------------------------------------------------------------------
SET SETTING_HOME=""

REM OPTION:
REM ---------------------------------  FILTER  ---------------------------------
REM | Filter out what files you want to restore                                |
REM | -Pattern=xxx-Type=yyy-Target=zzz                                         |
REM | where xxx is the filter pattern,                                         |
REM |       yyy is the filter type, whice can be one of the following:         |
REM |           [exact | exactMatchCase | contains | containsMatchCase|        |
REM |            startWith | startWithMatchCase | endWith | endWithMatchCase]  |
REM |       zzz is the filter target, which can be one of the following:       |
REM |           [toFile | toFileDir | toDir]                                   |
REM |                                                                          |
REM | e.g. SET FILTER="-Pattern=.txt-Type=exact-Target=toFile"                 |
REM ----------------------------------------------------------------------------
SET FILTER=""

REM --------------------------------  TEMP_DIR  --------------------------------
REM | Directory to where you want to store restore files temporarily           |
REM | Use "\\\\" instead of "\\" when you specify a UNC path                   |
REM | set to "" to use the temporary directory in the backup set               |
REM | e.g. SET TEMP_DIR="C:\Temp"                                              |
REM ----------------------------------------------------------------------------
SET TEMP_DIR=""

REM ####################  END: User Defined Section  ###########################

SET APP_HOME=..
SET JAVA_HOME=%APP_HOME%\jvm
SET JAVA_EXE=%JAVA_HOME%\bin\bJW.exe
SET JAVA_LIB_PATH=-Djava.library.path=%APP_HOME%\bin
SET PATH=%JAVA_HOME%\bin;%PATH%
SET CLASSPATH=%APP_HOME%\bin;%APP_HOME%\bin\cb.jar

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
  SET "DEP_LIB_PATH=X86"
  SET JAVA_OPTS=-Xms128m -Xmx768m -XX:MaxDirectMemorySize=512m -Dsun.java2d.noddraw -Dsun.nio.PageAlignDirectMemory=true
) ELSE (
  SET "DEP_LIB_PATH=X64"
  SET JAVA_OPTS=-Xms128m -Xmx2048m -XX:MaxDirectMemorySize=1024m -Dsun.java2d.noddraw -Dsun.nio.PageAlignDirectMemory=true
)
SET PATH=%CD%\%APP_HOME%\bin\%DEP_LIB_PATH%;%PATH%

REM #############################################################################
ECHO - 
ECHO APP_HOME=%APP_HOME%
ECHO SETTING_HOME=%SETTING_HOME%
ECHO JAVA_HOME=%JAVA_HOME%
ECHO JAVA_EXE=%JAVA_EXE%
ECHO JAVA_OPTS=%JAVA_OPTS%
ECHO JAVA_LIB_PATH=%JAVA_LIB_PATH%
ECHO PATH=%PATH%
ECHO CLASSPATH=%CLASSPATH%
ECHO - 

@ECHO ON
%JAVA_EXE% %JAVA_LIB_PATH% -cp %CLASSPATH% %JAVA_OPTS% Restore --to=%RESTORE_TO% --from=%RESTORE_FROM% --backup-set=%BACKUP_SET% --backup-dest=%DESTINATION% %REPLACE_EXISTING_FILE% --date=%POINT_IN_TIME% --set-permission=%RESTORE_PERMISSION% --skip-invalid-key=%SKIP_INVALID_KEY% --sync=%SYNC_OPTION% --filter=%FILTER% --temp-dir=%TEMP_DIR% --app-home=%APP_HOME% --setting-home=%SETTING_HOME%
@ECHO OFF
CD %APP_HOME%
IF "%APP_HOME%"==".." PAUSE
@ECHO ON