@ECHO OFF
REM ##################  ListBackupJob.bat  #####################################
REM # You can use this batch to list all backup jobs which ran under this      # 
REM # backup set.                                                              #
REM ############################################################################

REM ####################  Start: User Defined Section  #########################

REM -------------------------------  BACKUP_SET  -------------------------------
REM | The name or ID of the backup set that you want to run                    |
REM | If backup set name is not in English, please use BackupSetID             |
REM | e.g. SET BACKUP_SET="1119083740107"                                      |
REM |  or  SET BACKUP_SET="FileBackupSet-1"                                    |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 backup set.        |
REM ----------------------------------------------------------------------------
SET BACKUP_SET=""

REM ------------------------------  BACKUP_DEST  -------------------------------
REM | The name or ID of the destination that you want to list                  |
REM | If destination name is not in English, please use DestinationID          |
REM | e.g. SET BACKUP_DEST="1119083740107"                                     |
REM |  or  SET BACKUP_DEST="CBS"                                               |
REM |                                                                          |
REM | You can leave this parameter blank if you have only 1 destination.       |
REM ----------------------------------------------------------------------------
SET BACKUP_DEST=""

REM ####################  END: User Defined Section  ###########################

REM ############################################################################
REM #                SCRIPT                      USAGE                         #
REM ############################################################################

REM # Input Arguments will overwrite the above settings
REM # defined in 'User Defined Section'.
IF NOT %1.==. SET BACKUP_SET=%1
IF NOT %2.==. SET BACKUP_DEST=%2

REM #############################################################################
SET APP_HOME=..
SET SETTING_HOME=
SET JAVA_HOME=%APP_HOME%\jvm
SET JAVA_EXE=%JAVA_HOME%\bin\bJW.exe
SET JAVA_OPTS=-Xms128m -Xmx768m -Dsun.java2d.noddraw -Dsun.nio.PageAlignDirectMemory=true
SET JAVA_LIB_PATH=-Djava.library.path=%APP_HOME%\bin
SET PATH=%JAVA_HOME%\bin;%PATH%
SET CLASSPATH=%APP_HOME%\bin;%APP_HOME%\bin\cb.jar

REM #############################################################################
ECHO - 
ECHO APP_HOME=%APP_HOME%
ECHO SETTING_HOME=%SETTING_HOME%
ECHO JAVA_HOME=%JAVA_HOME%
ECHO JAVA_EXE=%JAVA_EXE%
ECHO JAVA_OPTS=%JAVA_OPTS%
ECHO JAVA_LIB_PATH=%JAVA_LIB_PATH%
ECHO PATH=%PATH%
ECHO CLASSPATH=%CLASSPATH%
ECHO - 

ECHO Listing all backup jobs for Backup Set - '%BACKUP_SET%' ...
@ECHO ON
%JAVA_EXE% %JAVA_LIB_PATH% -cp %CLASSPATH% %JAVA_OPTS% ListBackupJob --app-home=%APP_HOME% --backup-set=%BACKUP_SET% --backup-dest=%BACKUP_DEST% --setting-home=%SETTING_HOME%
PAUSE
