@ECHO OFF
SETLOCAL
SETLOCAL ENABLEDELAYEDEXPANSION
REM CLS
REM ################################################################
REM # You can use this batch to import the group and user          #
REM # directory objects to Active Directory                        #
REM #                                                              #
REM # Last Updated: 2012-12-11                                     #
REM ################################################################

REM //Variables
REM //User argument
SET "VAR_IMPT_HOSTNAME="
SET "VAR_IMPT_FILE_IN=fImport.ldf"
SET "VAR_IMPT_VERBOSE= "
SET "VAR_IMPT_PINFO=2"
SET "VAR_IMPT_FLAG=0"

REM //Parse input paraments
FOR %%i IN (%*) DO CALL :import_parseArgument %%i

IF %VAR_IMPT_PINFO% LSS 0 (
  CALL :import_printHelp
  GOTO import_exit
)

IF "%VAR_IMPT_HOSTNAME%"=="" (
  REM //Get computer hostname
  FOR /F "usebackq tokens=* delims=" %%i IN (`dsquery server -o rdn 2^>^&1`) DO SET "VAR_IMPT_HOSTNAME=%%i"
)

IF %VAR_IMPT_PINFO% GEQ 2 CALL :import_printConfig

REM //Check source file exist
IF NOT EXIST "%VAR_IMPT_FILE_IN%" (
  IF %VAR_IMPT_PINFO% GEQ 1 ECHO.File "%VAR_IMPT_FILE_IN%" not found
  GOTO import_exit
)

REM //Import AD from file
ldifde -i -k -f "%VAR_IMPT_FILE_IN%" -s %VAR_IMPT_HOSTNAME% %VAR_IMPT_VERBOSE%

REM //Exit point
:import_exit
REM //Delete variables
SET "VAR_IMPT_HOSTNAME="
SET "VAR_IMPT_FILE_IN="
SET "VAR_IMPT_VERBOSE="
SET "VAR_IMPT_PINFO="
SET "VAR_IMPT_FLAG="
ENDLOCAL
GOTO :eof


REM //Sub-routine to print help message
REM //In:
REM //Out:
:import_printHelp
ECHO.Input arguments:
ECHO.     fin:[input file]
ECHO.     hostname:[hostname]
ECHO.     verbose:[0/1/2]
ECHO.     help
ECHO.
ECHO. (Use double quotation marks the argument
ECHO.  if it contains any space char eg."argu ment")
ECHO.
ECHO.  fin - .ldf source file
ECHO.  hostname - computer hostname (auto detect if missing)
ECHO.  verbose - level of information show
ECHO.
GOTO :eof

REM //Sub-routine to print current config
REM //In:
REM //Out:
:import_printConfig
ECHO.Current config:
ECHO.     input file: %VAR_IMPT_FILE_IN%
ECHO.     hostname:   %VAR_IMPT_HOSTNAME%
ECHO.
GOTO :eof

REM //Sub-routine to parse input paraments
REM //In: [argument]
REM //Out:
:import_parseArgument
IF %VAR_IMPT_PINFO% LSS 0 GOTO import_parseArgument_exit
SET "VAR_IMPT_FLAG=0"
FOR /F "tokens=1,* delims=:" %%i IN ("%~1") DO (
  IF /I "%%i"=="HOSTNAME" SET "VAR_IMPT_HOSTNAME=%%j" & SET "VAR_IMPT_FLAG=1"
  IF /I "%%i"=="FIN" SET "VAR_IMPT_FILE_IN=%%j" & SET "VAR_IMPT_FLAG=1"
  IF /I "%%i"=="VERBOSE" (
    IF /I "%%j"=="1" SET "VAR_IMPT_VERBOSE=-j ." & SET "VAR_IMPT_FLAG=1"
    IF /I "%%j"=="2" SET "VAR_IMPT_VERBOSE=-v -j ." & SET "VAR_IMPT_FLAG=1"
  )
  IF /I "%%i"=="INFO" SET "VAR_IMPT_PINFO=%%j" & SET "VAR_IMPT_FLAG=1"

  REM //Default
  IF /I "%%j"=="" SET "VAR_IMPT_PINFO=-1"
  IF !VAR_IMPT_FLAG! LEQ 0 SET "VAR_IMPT_PINFO=-1"
)
:import_parseArgument_exit
GOTO :eof