@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM get application home
SET "EXE_HOME=%CD%"
CD "%~dp0"

REM check service exists
SET "TAG_STATUS_INSTALLED=Installed"
SET "SERVICE_STATUS="
SET "SERVICE_EXEC_PATH="
CALL :Sub_Query

IF NOT "%SERVICE_STATUS%"=="%TAG_STATUS_INSTALLED%" (
    ECHO.Service is not installed, exit now.
    GOTO Main_UnInstall_End
)
IF ""=="%SERVICE_EXEC_PATH%" (
    ECHO.Fail to get service execute path, exit now.
    GOTO Main_UnInstall_End
)

:Main_UnInstall_Start
CALL :Sub_Uninstall_Service

REM path should be something like "NFS_DIR\bin\xxx.exe"
ECHO.%SERVICE_EXEC_PATH%

SET "SERVICE_BIN="
CALL :Sub_Get_Parent "%SERVICE_EXEC_PATH%" SERVICE_BIN

SET "SERVICE_HOME="
CALL :Sub_Get_Parent "%SERVICE_BIN%" SERVICE_HOME

REM ECHO.%SERVICE_HOME%
IF EXIST "%SERVICE_HOME%" (
    ECHO.
    ECHO.Remove backup folder and files.
    RMDIR /S /Q "%SERVICE_HOME%"
)

:Main_UnInstall_Success
SET /A WAIT_STATUS_UPDATED_COUNT=1
:Main_UnInstall_Success_Check_Status
SET "SERVICE_STATUS="
CALL :Sub_Query
ECHO.Service status after un-installation: "%SERVICE_STATUS%"
IF %WAIT_STATUS_UPDATED_COUNT% GEQ 20 (
    ECHO.Service status is not updated after un-installation
    GOTO Main_UnInstall_End
)
IF "%SERVICE_STATUS%"=="%TAG_STATUS_INSTALLED%" (
    SET /A WAIT_STATUS_UPDATED_COUNT+=1
    GOTO :Main_UnInstall_Success_Check_Status
)

:Main_UnInstall_End
CD "%EXE_HOME%"
EXIT /B 0
ENDLOCAL

REM ------------------------------------------------
:Sub_Get_Parent
SET "PARENT_DIR=%~dp1"
REM strip trailing backslash
SET "%~2=%PARENT_DIR:~0,-1%"

:Sub_Get_Parent_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Left_Trim
FOR /f "tokens=* delims= " %%a IN ("%~1") DO (
    SET "%~2=%%a"
)

:Sub_Left_Trim_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Query
SET "TAG_STATUS_UNKNOWN=Unknown"
SET "TAG_STATUS_NOT_INSTALL=NotInstall"
SET "TAG_STATUS_NOT_ACCESSIBLE=NotAccessible"
SET "TAG_STATUS_RUNNING=Running"
SET "TAG_STATUS_STOPPED=Stopped"
SET "TAG_QUERY_PATH=Service Path:"
SET "TAG_QUERY_STATUS=Service Status:"

FOR /f "tokens=*" %%i IN ('CALL "Query.bat"') DO (
    CALL :Sub_Query_Parser "%%i"
)

:Sub_Query_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Query_Parser
SET "QUERY_RESULT=%~1"
SET "QUERY_CHECK=!QUERY_RESULT:%TAG_QUERY_PATH%=!"
IF NOT "!QUERY_CHECK!"=="!QUERY_RESULT!" (
    CALL :Sub_Left_Trim "!QUERY_CHECK!" SERVICE_EXEC_PATH
    GOTO Sub_Query_Parser_Exit
)
SET "QUERY_CHECK=!QUERY_RESULT:%TAG_QUERY_STATUS%=!"
IF NOT "!QUERY_CHECK!"=="!QUERY_RESULT!" (
    CALL :Sub_Left_Trim "!QUERY_CHECK!" QUERY_CHECK
    IF "!QUERY_CHECK!"=="%TAG_STATUS_RUNNING%" (
        SET "SERVICE_STATUS=%TAG_STATUS_INSTALLED%"
        GOTO Sub_Query_Parser_Exit
    )
    IF "!QUERY_CHECK!"=="%TAG_STATUS_STOPPED%" (
        SET "SERVICE_STATUS=%TAG_STATUS_INSTALLED%"
        GOTO Sub_Query_Parser_Exit
    )    
    REM un-defined status
    SET "SERVICE_STATUS=!QUERY_CHECK!"
    GOTO Sub_Query_Parser_Exit
)

:Sub_Query_Parser_Exit
GOTO:EOF

REM ------------------------------------------------
:Sub_Uninstall_Service
SET "SERVICE_NAME=OBNfsServer"
SET "SERVICE_UTIL=Service.exe"

REM get service status
SET "SERVICE_LOGON="
FOR /f "tokens=*" %%i IN ('%SERVICE_UTIL% -n %SERVICE_NAME%') DO (
    SET "SERVICE_LOGON=%%i"
    GOTO Sub_Uninstall_Service_Check_Status
)

:Sub_Uninstall_Service_Check_Status
REM check if service could be listed
IF ""=="%SERVICE_LOGON%" (
    ECHO.No need to uninstall service "%SERVICE_NAME%" because it is not installed.
    GOTO Main_End
)

REM remove NFS service
"%SERVICE_UTIL%" -r "%SERVICE_NAME%"

:Sub_Uninstall_Service_Exit
GOTO:EOF