@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM get application home
SET "EXE_HOME=%CD%"
CALL :Sub_Change_Directory "%~dp0"
SET "APP_BIN=%CD%"
SET "APP_HOME="
CALL :Sub_Get_Parent "%APP_BIN%" APP_HOME
IF ""=="%APP_HOME%" (
    ECHO.Fail to get application home, exit now.
    GOTO Main_Install_End
)

REM define NFS file list in installation location
REM SET "NFS_FILE_LIST=nfsX86.exe nfsX64.exe vSphereWebCtrlWinX86.exe vSphereWebCtrlWinX64.exe"
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
    SET "NFS_FILE_LIST=nfsX86.exe vSphereWebCtrlWinX86.exe"
) ELSE (
    SET "NFS_FILE_LIST=nfsX64.exe vSphereWebCtrlWinX64.exe"
)

REM check service exists
SET "TAG_STATUS_INSTALLED=Installed"
SET "TAG_STATUS_NOT_INSTALL=NotInstall"
SET "TAG_STATUS_RUNNING=Running"
SET "SERVICE_STATUS="
SET "SERVICE_EXEC_PATH="
CALL :Sub_Query

REM if service is running, add back any missing file to install location, otherwise, uninstall NFS service and reinstall
IF "%SERVICE_STATUS%"=="%TAG_STATUS_RUNNING%" (
    ECHO.Service is running already, start repair process
    SET "EXISTING_SERVICE_INSTALL_LOCATION="
    CALL :Sub_Get_Parent "%SERVICE_EXEC_PATH%" EXISTING_SERVICE_INSTALL_LOCATION
    CALL :Sub_Install_NFS_Files "!EXISTING_SERVICE_INSTALL_LOCATION!"
    ECHO.Repair process is completed
    GOTO Main_Install_End
) ELSE IF "%SERVICE_STATUS%"=="%TAG_STATUS_INSTALLED%" (
    ECHO.Service is not running, start reinstall process
    CALL :Sub_Uninstall_Service
) ELSE (
    ECHO.Service is not installed, start install process
)

REM backup exist package 
SET "INSTALL_ROOT=%APP_HOME%"
CALL :Sub_Get_Parent "%INSTALL_ROOT%" INSTALL_ROOT
CALL :Sub_Get_Name "%INSTALL_ROOT%" PACKAGE_FOLDER
IF ""=="%PACKAGE_FOLDER%" (
    ECHO.Fail to get application folder name, exit now.
    GOTO Main_Install_End
)
SET "PACKAGE_FOLDER=%PACKAGE_FOLDER% NFS"
CALL :Sub_Get_Parent "%INSTALL_ROOT%" INSTALL_ROOT
SET "BACKUP_PACKAGE_FOLDER="

IF NOT EXIST "%INSTALL_ROOT%\%PACKAGE_FOLDER%" (
    GOTO Main_Copy_Package
)

:Backup_Exist_Package_Folder
SET /A COUNT=1
:Verify_Package_Folder_Loop
SET "BACKUP_PACKAGE_FOLDER=%PACKAGE_FOLDER%_!COUNT!"
IF EXIST "%INSTALL_ROOT%\!BACKUP_PACKAGE_FOLDER!" (
    SET /A COUNT+=1
    GOTO Verify_Package_Folder_Loop
)
ECHO.
ECHO.Rename folder from "%PACKAGE_FOLDER%" to "!BACKUP_PACKAGE_FOLDER!"
CALL :Sub_Change_Directory "%INSTALL_ROOT%"
REN "%PACKAGE_FOLDER%" "!BACKUP_PACKAGE_FOLDER!"
IF %ERRORLEVEL% NEQ 0 (
    ECHO.Fail to backup existing NFS files, exit now.
    GOTO Main_Install_End
)

:Main_Copy_Package
REM copy NFS files to install location
ECHO.
ECHO.Copying package folder and files...

REM copy nfs executables to install location
SET "INSTALL_LOCATION=%INSTALL_ROOT%\%PACKAGE_FOLDER%\bin"
CALL :Sub_Install_NFS_Files "%INSTALL_LOCATION%"

IF !ERRORLEVEL! NEQ 0 (
    ECHO.Fail to copy package folder and files, exit now.
    GOTO Main_Install_Rollback
)

:Main_Install_Start
REM install service script from service util location
CALL :Sub_Change_Directory "%APP_BIN%"
CALL :Sub_Install_Service "%INSTALL_LOCATION%"

:Main_Install_Success
SET /A WAIT_STATUS_UPDATED_COUNT=1
:Main_Install_Success_Check_Status
SET "SERVICE_STATUS="
CALL :Sub_Query
ECHO.Service status after installation: "%SERVICE_STATUS%"
IF "%SERVICE_STATUS%"=="%TAG_STATUS_RUNNING%" (
    GOTO Main_Install_Done
)
IF %WAIT_STATUS_UPDATED_COUNT% GEQ 20 (
    ECHO.Service status is not updated after installation
    GOTO Main_Install_Done
)
SET /A WAIT_STATUS_UPDATED_COUNT+=1
GOTO Main_Install_Success_Check_Status

:Main_Install_Done
REM remove backup package 
IF NOT ""=="!BACKUP_PACKAGE_FOLDER!" (
    CALL :Sub_Change_Directory "%INSTALL_ROOT%"
    IF EXIST "!BACKUP_PACKAGE_FOLDER!" (
        ECHO.
        ECHO.Remove backup folder and files.
        RMDIR /S /Q "!BACKUP_PACKAGE_FOLDER!"
    )
)
GOTO Main_Install_End

:Main_Install_Rollback
REM revert changes by restore backup folder to original
CALL :Sub_Change_Directory "%INSTALL_ROOT%"
RMDIR /S /Q "%PACKAGE_FOLDER%"
IF EXIST "!BACKUP_PACKAGE_FOLDER!" (
    ECHO.Rename folder from "!BACKUP_PACKAGE_FOLDER!" back to "%PACKAGE_FOLDER%"
    REN "!BACKUP_PACKAGE_FOLDER!" "%PACKAGE_FOLDER%"
    IF !ERRORLEVEL! NEQ 0 (
        ECHO.Fail to restore "!BACKUP_PACKAGE_FOLDER!" as "%PACKAGE_FOLDER%" in "%INSTALL_ROOT%".
    )
)

:Main_Install_End
CALL :Sub_Change_Directory "%EXE_HOME%"
EXIT /B 0
ENDLOCAL

REM ------------------------------------------------
:Sub_Get_Parent
SET "PARENT_DIR=%~dp1"
REM strip trailing backslash
SET "%~2=%PARENT_DIR:~0,-1%"

:Sub_Get_Parent_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Get_Name
SET "PARENT_DIR=%~nx1"
SET "%~2=%PARENT_DIR%"

:Sub_Get_Name_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Left_Trim
FOR /f "tokens=* delims= " %%a IN ("%~1") DO (
    SET "%~2=%%a"
)

:Sub_Left_Trim_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Change_Directory
SET TARGET_DIR=%~1
REM if target dir is drive without trailing slash, add trailing slash before change directory to avoid fail
IF "%TARGET_DIR%"=="%TARGET_DIR:~0,2%" (
    SET TARGET_DIR=%TARGET_DIR%\
)
CD %TARGET_DIR%
:Sub_Change_Directory_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Query
SET "TAG_STATUS_UNKNOWN=Unknown"
SET "TAG_STATUS_NOT_ACCESSIBLE=NotAccessible"
SET "TAG_STATUS_STOPPED=Stopped"
SET "TAG_QUERY_STATUS=Service Status:"
SET "TAG_SERVICE_PATH=Service Path:"

FOR /f "tokens=*" %%i IN ('CALL "Query.bat"') DO (
    CALL :Sub_Query_Parser "%%i"
)

:Sub_Query_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Query_Parser
SET "QUERY_RESULT=%~1"
SET "QUERY_CHECK=!QUERY_RESULT:%TAG_QUERY_STATUS%=!"
SET "QUERY_SERVICE_PATH_CHECK=!QUERY_RESULT:%TAG_SERVICE_PATH%=!"
IF NOT "!QUERY_CHECK!"=="!QUERY_RESULT!" ( REM get service status
    CALL :Sub_Left_Trim "!QUERY_CHECK!" QUERY_CHECK
    IF "!QUERY_CHECK!"=="%TAG_STATUS_RUNNING%" (
        SET "SERVICE_STATUS=%TAG_STATUS_RUNNING%"
    ) ELSE IF "!QUERY_CHECK!"=="%TAG_STATUS_STOPPED%" (
        SET "SERVICE_STATUS=%TAG_STATUS_INSTALLED%"
    ) ELSE (
        REM un-defined status
        SET "SERVICE_STATUS=!QUERY_CHECK!"
    )
) ELSE IF NOT "!QUERY_SERVICE_PATH_CHECK!"=="!QUERY_RESULT!" ( REM get service path
    CALL :Sub_Left_Trim "!QUERY_SERVICE_PATH_CHECK!" QUERY_SERVICE_PATH_CHECK
    SET "SERVICE_EXEC_PATH=!QUERY_SERVICE_PATH_CHECK!"
)

:Sub_Query_Parser_Exit
GOTO:EOF

REM ------------------------------------------------
:Sub_Install_NFS_Files
SET "TARGET_LOCATION=%~1"
REM create install location before copying to ensure copy command know TARGET_LOCATION is directory
IF NOT EXIST "%TARGET_LOCATION%" (
    MKDIR "%TARGET_LOCATION%"
)
ECHO.Install NFS files to %TARGET_LOCATION%
CALL :Sub_Change_Directory "%APP_BIN%"
FOR %%a IN (%NFS_FILE_LIST%) DO (
    SET "FILE_NAME=%%a"
    ECHO.Check if NFS file "!FILE_NAME!" exists
    REM remove if folder exists instead of file
    IF EXIST "%TARGET_LOCATION%\!FILE_NAME!\" (
        RMDIR /S /Q "%TARGET_LOCATION%\!FILE_NAME!\"
    )
    IF NOT EXIST "%TARGET_LOCATION%\!FILE_NAME!" (
        ECHO."!FILE_NAME!" does not exist, repairing...
        COPY "%CD%\!FILE_NAME!" "%TARGET_LOCATION%" /Y
        REM IF !ERRORLEVEL! NEQ 0 (
        REM     GOTO Sub_Install_NFS_Files_End
        REM )
    ) ELSE (
        ECHO."!FILE_NAME!" exists already
    )
)
:Sub_Install_NFS_Files_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Install_Service
SET "INSTALL_LOCATION=%~1"
SET "SERVICE_UTIL=Service.exe"
SET "SERVICE_NAME=OBNfsServer"
SET "SERVICE_DISPLAY_NAME=NFS Service (Evolpro IT Solutions)"
SET "SERVICE_DESCRIPTION=RunDirect Network File System Service of Evolpro IT Solutions"
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
    SET "NFS_EXE=nfsX86.exe"
) ELSE (
    SET "NFS_EXE=nfsX64.exe"
)

REM check NFS service exist
SET "SERVICE_LOGON="
FOR /f "tokens=*" %%i IN ('%SERVICE_UTIL% -n %SERVICE_NAME%') DO (
    SET "SERVICE_LOGON=%%i"
    GOTO Sub_Install_Service_Check_Status
)

:Sub_Install_Service_Check_Status
REM check if service could be listed
IF ""=="%SERVICE_LOGON%" (
    REM install NFS service
    "%SERVICE_UTIL%" -i "%SERVICE_NAME%" "%SERVICE_DISPLAY_NAME%" "%INSTALL_LOCATION%\%NFS_EXE%" "%SERVICE_DESCRIPTION%"
) ELSE {
    REM rename NFS service if exists
    "%SERVICE_UTIL%" -u "%SERVICE_NAME%" "%SERVICE_DISPLAY_NAME%" "%INSTALL_LOCATION%\%NFS_EXE%" "%SERVICE_DESCRIPTION%"
)

REM start NFS service
SC Start "%SERVICE_NAME%"

:Sub_Install_Service_Exit
GOTO:EOF

REM ------------------------------------------------
:Sub_Uninstall_Service
CALL UninstallService.bat

:Sub_Uninstall_Service_Exit
GOTO:EOF