/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.text.Collator;
import java.util.Locale;
import java.util.ResourceBundle;

public class KeyStoreUtil {
    private static final String JKS = "jks";
    private static final Collator collator = Collator.getInstance();

    private KeyStoreUtil() {
    }

    public static boolean isWindowsKeyStore(String string) {
        return string.equalsIgnoreCase("Windows-MY") || string.equalsIgnoreCase("Windows-ROOT");
    }

    public static String niceStoreTypeName(String string) {
        if (string.equalsIgnoreCase("Windows-MY")) {
            return "Windows-MY";
        }
        if (string.equalsIgnoreCase("Windows-ROOT")) {
            return "Windows-ROOT";
        }
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static KeyStore getCacertsKeyStore() throws Exception {
        String string = File.separator;
        File file = new File(System.getProperty("java.home") + string + "lib" + string + "security" + string + "cacerts");
        if (!file.exists()) {
            return null;
        }
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            keyStore = KeyStore.getInstance(JKS);
            keyStore.load(fileInputStream, null);
        }
        return keyStore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getPassWithModifier(String string, String string2, ResourceBundle resourceBundle) {
        if (string == null) {
            return string2.toCharArray();
        }
        if (collator.compare(string, "env") == 0) {
            String string4 = System.getenv(string2);
            if (string4 != null) return string4.toCharArray();
            System.err.println(resourceBundle.getString("Cannot.find.environment.variable.") + string2);
            return null;
        }
        if (collator.compare(string, "file") != 0) {
            System.err.println(resourceBundle.getString("Unknown.password.type.") + string);
            return null;
        }
        try {
            Serializable serializable;
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                serializable = new File(string2);
                if (!((File)serializable).exists()) {
                    System.err.println(resourceBundle.getString("Cannot.find.file.") + string2);
                    return null;
                }
                uRL = ((File)serializable).toURI().toURL();
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            serializable = null;
            try {
                String string3 = bufferedReader.readLine();
                if (string3 == null) {
                    char[] cArray2 = new char[]{};
                    return cArray2;
                }
                char[] cArray = string3.toCharArray();
                return cArray;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (bufferedReader != null) {
                    if (serializable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
    }

    static {
        collator.setStrength(0);
    }
}

