/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.logging;

import com.easyeda.utils.Utils;
import com.easyeda.utils.logging.DummyLogger;
import com.easyeda.utils.logging.LOGLEVEL;

public abstract class Logger {
    public static final DummyLogger DUMMY = new DummyLogger();
    private LOGLEVEL level;

    public static LOGLEVEL toLevel(String level) {
        return Enum.valueOf(LOGLEVEL.class, level.toUpperCase());
    }

    public Logger(LOGLEVEL level) {
        this.level = level;
    }

    public Logger() {
        this.level = LOGLEVEL.ERROR;
    }

    public LOGLEVEL getLevel() {
        return this.level;
    }

    public boolean include(LOGLEVEL l) {
        return this.level.include(l);
    }

    public void debug(String format, Object ... args) {
        if (this.include(LOGLEVEL.DEBUG)) {
            this._debug(String.format(format, args));
        }
    }

    public void debug(String message) {
        if (this.include(LOGLEVEL.DEBUG)) {
            this._debug(message);
        }
    }

    public void debug(Object o) {
        if (this.include(LOGLEVEL.DEBUG)) {
            this._debug(o.toString());
        }
    }

    public void info(String format, Object ... args) {
        if (this.include(LOGLEVEL.INFO)) {
            this._info(String.format(format, args));
        }
    }

    public void info(String message) {
        if (this.include(LOGLEVEL.INFO)) {
            this._info(message);
        }
    }

    public void info(Object o) {
        if (this.include(LOGLEVEL.INFO)) {
            this._info(o.toString());
        }
    }

    public void warning(String format, Object ... args) {
        if (this.include(LOGLEVEL.WARNING)) {
            this._warning(String.format(format, args));
        }
    }

    public void warning(String message) {
        if (this.include(LOGLEVEL.WARNING)) {
            this._warning(message);
        }
    }

    public void warning(Object o) {
        if (this.include(LOGLEVEL.WARNING)) {
            this._warning(o.toString());
        }
    }

    public void error(String format, Object ... args) {
        if (this.include(LOGLEVEL.ERROR)) {
            this._error(String.format(format, args));
        }
    }

    public void error(String message) {
        if (this.include(LOGLEVEL.ERROR)) {
            this._error(message);
        }
    }

    public void error(Object o) {
        if (this.include(LOGLEVEL.ERROR)) {
            this._error(o.toString());
        }
    }

    public void error(Throwable o) {
        if (this.include(LOGLEVEL.ERROR)) {
            this._error(Utils.getStackTrace(o));
        }
    }

    protected abstract void _debug(String var1);

    protected abstract void _info(String var1);

    protected abstract void _warning(String var1);

    protected abstract void _error(String var1);
}

