/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.Validation;
import com.easyeda.utils.json.AbstractJsonParser;
import com.easyeda.utils.json.InvalidJSON;
import com.easyeda.utils.json.JArray;
import com.easyeda.utils.json.JMap;
import com.easyeda.utils.json.JObject;
import com.easyeda.utils.logging.LOGLEVEL;
import com.easyeda.utils.logging.Logger;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class Parser
extends AbstractJsonParser {
    private final Logger log;
    private final Deque<State> stateStack = new LinkedList<State>();
    private JObject result = null;
    private int line = 1;
    private int col = 0;

    public Parser(Logger log) {
        this.log = Validation.NPE(log);
    }

    public JObject parseSingle(String content) throws InvalidJSON {
        int len = content.length();
        for (int i = 0; i <= len && this.result == null; ++i) {
            if (i == len) {
                this.finish();
                continue;
            }
            char c = content.charAt(i);
            this.feed(c);
        }
        if (this.result == null) {
            throw new InvalidJSON();
        }
        return this.result;
    }

    public List<JObject> parseMultiple(String content) throws InvalidJSON {
        int len = content.length();
        LinkedList<JObject> results = new LinkedList<JObject>();
        for (int i = 0; i <= len; ++i) {
            if (i == len) {
                this.finish();
            } else {
                char c = content.charAt(i);
                this.feed(c);
            }
            if (this.result == null) continue;
            results.add(this.result);
            this.result = null;
        }
        if (results.isEmpty()) {
            throw new InvalidJSON();
        }
        return results;
    }

    public void feed(char c) throws InvalidJSON {
        if (c == '\n') {
            ++this.line;
            this.col = 0;
        } else {
            ++this.col;
        }
        if (this.log.include(LOGLEVEL.DEBUG)) {
            this.log.debug("line %d col %d: char %s, state %s", this.line, this.col, Character.valueOf(c), this.getState().name());
        }
        this._feed(c);
    }

    private void auto(JObject o) throws InvalidJSON {
        if (this.stateStack.isEmpty()) {
            this.result = o;
        } else {
            State st = this.stateStack.peek();
            if (st instanceof MapState) {
                ((MapState)st).add(o);
            } else if (st instanceof ArrayState) {
                ((ArrayState)st).add(o);
            } else {
                throw new InvalidJSON("unknow state " + st.getClass().getName());
            }
        }
    }

    @Override
    public void onMapStart() throws InvalidJSON {
        this.stateStack.push(new MapState());
    }

    @Override
    public void onArrayStart() throws InvalidJSON {
        this.stateStack.push(new ArrayState());
    }

    @Override
    public void onMapEnd() throws InvalidJSON {
        State st = this.stateStack.pop();
        if (!(st instanceof MapState)) {
            throw new InvalidJSON("unexpected }");
        }
        this.auto(st.end());
    }

    @Override
    public void onArrayEnd() throws InvalidJSON {
        State st = this.stateStack.pop();
        if (!(st instanceof ArrayState)) {
            throw new InvalidJSON("unexpected ]");
        }
        this.auto(st.end());
    }

    @Override
    public void onJObject(JObject o) throws InvalidJSON {
        this.auto(o);
    }

    public JObject getResult() {
        if (this.result != null) {
            JObject rst = this.result;
            this.result = null;
            return rst;
        }
        return null;
    }

    private class MapState
    extends State {
        private final JMap map;
        private boolean isKey;
        private Object key;

        public MapState() {
            this.isKey = true;
            this.map = new JMap();
        }

        private void add(JObject o) {
            if (this.isKey) {
                this.key = o;
                this.isKey = false;
            } else {
                this.map.put(this.key, (Object)o);
                this.isKey = true;
            }
        }

        @Override
        public JObject end() throws InvalidJSON {
            if (this.isKey) {
                return this.map;
            }
            throw new InvalidJSON("incomplete map items");
        }
    }

    private class ArrayState
    extends State {
        private final JArray array;

        private ArrayState() {
            this.array = new JArray();
        }

        private void add(JObject o) {
            this.array.add(o);
        }

        @Override
        public JObject end() throws InvalidJSON {
            return this.array;
        }
    }

    private abstract class State {
        private State() {
        }

        public abstract JObject end() throws InvalidJSON;
    }
}

