/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.Validation;
import com.easyeda.utils.json.AbstractJsonParser;
import com.easyeda.utils.json.InvalidJSON;
import com.easyeda.utils.json.JObject;
import java.util.LinkedList;

public class JsonWatcherParser
extends AbstractJsonParser {
    private final JsonWatcher[] watchers;
    private final LinkedList<State> stateStack = new LinkedList();
    private State currentState = null;

    public JsonWatcherParser(JsonWatcher ... watchers) {
        for (JsonWatcher w : Validation.NPE(watchers)) {
            Validation.NPE(w);
        }
        this.watchers = watchers;
    }

    public void feed(char c) throws InvalidJSON {
        this._feed(c);
    }

    private String buildJsonPath() {
        StringBuilder sb = new StringBuilder();
        for (State s : this.stateStack) {
            if (s instanceof MapState) {
                if (sb.length() > 0) {
                    sb.append(".");
                }
                sb.append(((MapState)s).currentKey);
                continue;
            }
            if (!(s instanceof ArrayState)) continue;
            sb.append(String.format("[%d]", ((ArrayState)s).index));
        }
        return sb.toString();
    }

    private void exec(JObject jo) throws InvalidJSON {
        for (JsonWatcher w : this.watchers) {
            try {
                w.watcher(this.buildJsonPath(), jo);
            }
            catch (Exception e) {
                throw new InvalidJSON(e);
            }
        }
    }

    @Override
    public void onMapStart() throws InvalidJSON {
        if (this.currentState instanceof MapState) {
            MapState ms = (MapState)this.currentState;
            if (ms.isKey) {
                throw new InvalidJSON("unexpected {");
            }
            ms.isKey = true;
        }
        this.currentState = new MapState();
        this.stateStack.addLast(this.currentState);
        this.exec(null);
    }

    @Override
    public void onArrayStart() throws InvalidJSON {
        if (this.currentState instanceof MapState) {
            MapState ms = (MapState)this.currentState;
            if (ms.isKey) {
                throw new InvalidJSON("unexpected [");
            }
            ms.isKey = true;
        }
        this.currentState = new ArrayState();
        this.stateStack.addLast(this.currentState);
        this.exec(null);
    }

    @Override
    public void onMapEnd() throws InvalidJSON {
        if (this.currentState instanceof MapState) {
            MapState ms = (MapState)this.currentState;
            if (!ms.isKey) {
                throw new InvalidJSON("unexpected }");
            }
        } else {
            throw new InvalidJSON("unexpected }");
        }
        this.stateStack.removeLast();
        this.currentState = this.stateStack.peekLast();
    }

    @Override
    public void onArrayEnd() throws InvalidJSON {
        if (!(this.currentState instanceof ArrayState)) {
            throw new InvalidJSON("unexpected ]");
        }
        this.stateStack.removeLast();
        this.currentState = this.stateStack.peekLast();
    }

    @Override
    public void onJObject(JObject o) throws InvalidJSON {
        if (this.currentState instanceof ArrayState) {
            ++((ArrayState)this.currentState).index;
            this.exec(o);
        } else if (this.currentState instanceof MapState) {
            MapState ms = (MapState)this.currentState;
            if (ms.isKey) {
                ms.currentKey = o.asString();
                ms.isKey = false;
            } else {
                this.exec(o);
                ms.isKey = true;
            }
        }
    }

    private class MapState
    extends State {
        boolean isKey;
        String currentKey;

        private MapState() {
            this.isKey = true;
            this.currentKey = "";
        }
    }

    private class ArrayState
    extends State {
        long index;

        private ArrayState() {
            this.index = -1L;
        }
    }

    public abstract class State {
    }

    public static interface JsonWatcher {
        public void watcher(String var1, JObject var2) throws Exception;
    }
}

