/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.Validation;
import com.easyeda.utils.json.AbstractJsonParser;
import com.easyeda.utils.json.InvalidJSON;
import com.easyeda.utils.json.JBool;
import com.easyeda.utils.json.JNull;
import com.easyeda.utils.json.JNumber;
import com.easyeda.utils.json.JObject;
import com.easyeda.utils.json.JString;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JsonDeserializer
extends AbstractJsonParser {
    private final List<Object> results = new LinkedList<Object>();
    private final Deque<State> stateStack = new LinkedList<State>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object des(String src) throws InvalidJSON {
        Validation.NPE(src);
        try (StringReader rd = new StringReader(src);){
            Object object = JsonDeserializer.des(rd);
            return object;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Object des(Reader rd) throws IOException, InvalidJSON {
        int b;
        Validation.NPE(rd);
        JsonDeserializer des = new JsonDeserializer();
        while ((b = rd.read()) != -1) {
            des._feed((char)b);
        }
        return des.result();
    }

    @Override
    public void onMapStart() throws InvalidJSON {
        this.stateStack.addLast(new MapState());
    }

    @Override
    public void onArrayStart() throws InvalidJSON {
        this.stateStack.addLast(new ArrayState());
    }

    @Override
    public void onMapEnd() throws InvalidJSON {
        State st = this.stateStack.pop();
        if (st == null || !(st instanceof MapState)) {
            throw new InvalidJSON("unexpected }");
        }
        this.auto(st.end());
    }

    @Override
    public void onArrayEnd() throws InvalidJSON {
        State st = this.stateStack.pop();
        if (st == null || !(st instanceof ArrayState)) {
            throw new InvalidJSON("unexpected ]");
        }
        this.auto(st.end());
    }

    @Override
    public void onJObject(JObject o) throws InvalidJSON {
        Object deserialized;
        if (o instanceof JString) {
            deserialized = o.asString();
        } else if (o instanceof JNumber) {
            deserialized = o.asDouble();
        } else if (o instanceof JBool) {
            deserialized = o.asBoolean();
        } else if (o instanceof JNull) {
            deserialized = null;
        } else {
            throw new InvalidJSON(String.format("unknow type %s to desrialize", o.getClass().getName()));
        }
        this.auto(deserialized);
    }

    private void auto(Object o) throws InvalidJSON {
        State current = this.stateStack.peekLast();
        if (current == null) {
            this.results.add(o);
        } else if (current instanceof MapState) {
            ((MapState)current).add(o);
        } else if (current instanceof ArrayState) {
            ((ArrayState)current).add(o);
        } else {
            throw new InvalidJSON("unknow state " + current.getClass().getName());
        }
    }

    private Object result() {
        int size = this.results.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return this.results.get(0);
        }
        return this.results;
    }

    private class MapState
    extends State {
        private final Map<Object, Object> map;
        private boolean isKey;
        private Object key;

        public MapState() {
            this.isKey = true;
            this.map = new LinkedHashMap<Object, Object>();
        }

        private void add(Object o) {
            if (this.isKey) {
                this.key = o;
                this.isKey = false;
            } else {
                this.map.put(this.key, o);
                this.isKey = true;
            }
        }

        @Override
        public Object end() throws InvalidJSON {
            if (this.isKey) {
                return this.map;
            }
            throw new InvalidJSON("incomplete map items");
        }
    }

    private class ArrayState
    extends State {
        private final List<Object> array;

        private ArrayState() {
            this.array = new LinkedList<Object>();
        }

        private void add(Object o) {
            this.array.add(o);
        }

        @Override
        public Object end() throws InvalidJSON {
            return this.array;
        }
    }

    private abstract class State {
        private State() {
        }

        public abstract Object end() throws InvalidJSON;
    }
}

