/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.json.JObject;
import java.io.IOException;
import java.io.Writer;

public final class JString
extends JObject {
    private static final long serialVersionUID = 7880039119286718546L;
    private final String inner_string;

    public JString(String s) {
        this.inner_string = s;
    }

    private static void encode(Writer w, String s) throws IOException {
        int len = s.length();
        w.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    w.append("\\r");
                    continue block9;
                }
                case '\n': {
                    w.append("\\n");
                    continue block9;
                }
                case '\t': {
                    w.append("\\t");
                    continue block9;
                }
                case '\b': {
                    w.append("\\b");
                    continue block9;
                }
                case '\f': {
                    w.append("\\f");
                    continue block9;
                }
                case '\\': {
                    w.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    w.append("\\\"");
                    continue block9;
                }
                default: {
                    if (' ' <= c && c <= '~') {
                        w.append(c);
                        continue block9;
                    }
                    w.append(String.format("\\u%04x", c));
                }
            }
        }
        w.append('\"');
    }

    @Override
    public String asString() {
        return this.inner_string;
    }

    public boolean equals(Object o) {
        if (o.getClass() == JString.class) {
            return this.inner_string.equals(((JString)o).inner_string);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.inner_string.hashCode();
    }

    @Override
    public String toString() {
        return this.inner_string;
    }

    @Override
    void toJson(Writer w, int deep, int indent) throws IOException {
        JString.encode(w, this.inner_string);
    }
}

