/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.json.InvalidJSON;
import com.easyeda.utils.json.JArray;
import com.easyeda.utils.json.JBool;
import com.easyeda.utils.json.JMap;
import com.easyeda.utils.json.JNull;
import com.easyeda.utils.json.JNumber;
import com.easyeda.utils.json.JString;
import com.easyeda.utils.json.Parser;
import com.easyeda.utils.logging.Logger;
import com.easyeda.utils.logging.ScreenLogger;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public abstract class JObject
implements Serializable {
    private static final long serialVersionUID = -6546125952176887759L;

    public static JObject parseSingle(String content, Logger log) throws InvalidJSON {
        Parser h = new Parser(log);
        return h.parseSingle(content);
    }

    public static JObject parseSingle(String content) throws InvalidJSON {
        Parser h = new Parser(Logger.DUMMY);
        return h.parseSingle(content);
    }

    public static List<JObject> parseMultiple(String content, ScreenLogger log) throws InvalidJSON {
        Parser h = new Parser(log);
        return h.parseMultiple(content);
    }

    public static List<JObject> parseMultiple(String content) throws InvalidJSON {
        Parser h = new Parser(Logger.DUMMY);
        return h.parseMultiple(content);
    }

    public String toJson() {
        return this.toJson(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toJson(int indent) {
        try (CharArrayWriter w = new CharArrayWriter();){
            this.toJson(w, 0, indent);
            String string = ((Object)w).toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toJson(Writer w) throws IOException {
        this.toJson(w, 0, 0);
    }

    public void toJson(Writer w, int indent) throws IOException {
        this.toJson(w, 0, indent);
    }

    private JObject get(Object[] keys, int offset, int length) {
        JObject cur = this;
        for (int i = offset; i < length && cur != null; ++i) {
            if (JMap.class.isInstance(cur)) {
                cur = cur.asJMap().get(JObject.auto(keys[i]));
                continue;
            }
            if (JArray.class.isInstance(cur)) {
                cur = cur.asJArray().get((Integer)keys[i]);
                continue;
            }
            return null;
        }
        if (cur == null) {
            return null;
        }
        return cur;
    }

    public JObject get(Object ... keys) {
        if (keys.length < 1) {
            throw new IllegalArgumentException();
        }
        return this.get(keys, 0, keys.length);
    }

    public JObject getOrDefault(Object ... keys) {
        if (keys.length < 2) {
            throw new IllegalArgumentException();
        }
        JObject ret = this.get(keys, 0, keys.length - 1);
        if (ret == null) {
            return JObject.auto(keys[keys.length - 1]);
        }
        return ret;
    }

    abstract void toJson(Writer var1, int var2, int var3) throws IOException;

    public String toString() {
        return this.toJson();
    }

    public String asString() {
        throw new UnsupportedOperationException();
    }

    public int asInt() {
        throw new UnsupportedOperationException();
    }

    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    public JMap asJMap() {
        throw new UnsupportedOperationException();
    }

    public JArray asJArray() {
        throw new UnsupportedOperationException();
    }

    public JObject put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public JObject remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void add(Object o) {
        throw new UnsupportedOperationException();
    }

    public static JObject auto(Object o) {
        if (o == null) {
            return JNull.NULL;
        }
        if (o instanceof JObject) {
            return (JObject)o;
        }
        if (o instanceof Integer) {
            return new JNumber(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return new JNumber(((Long)o).longValue());
        }
        if (o instanceof Float) {
            return new JNumber(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return new JNumber((Double)o);
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return JBool.TRUE;
            }
            return JBool.FALSE;
        }
        if (o instanceof Iterable) {
            return new JArray((Iterable)o);
        }
        if (o instanceof Map) {
            return new JMap((Map)o);
        }
        return new JString(o.toString());
    }

    public JObject deepCopy() {
        try {
            return JObject.parseSingle(this.toJson());
        }
        catch (InvalidJSON e) {
            throw new RuntimeException(e);
        }
    }

    public abstract int hashCode();
}

