/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.Utils;
import com.easyeda.utils.json.JObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class JMap
extends JObject {
    private static final long serialVersionUID = 8945823021410448498L;
    private final LinkedHashMap<JObject, JObject> inner_map = new LinkedHashMap();

    public static JMap build(Object ... kvs) {
        if (kvs.length % 2 == 0) {
            JMap m = new JMap();
            for (int i = 0; i < kvs.length; i += 2) {
                m.put(kvs[i], kvs[i + 1]);
            }
            return m;
        }
        throw new IllegalArgumentException("key-value pair is not completed");
    }

    public JMap() {
    }

    public <K, V> JMap(Map<K, V> m) {
        this();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public JMap asJMap() {
        return this;
    }

    public int size() {
        return this.inner_map.size();
    }

    public boolean isEmpty() {
        return this.inner_map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.inner_map.containsKey(JMap.auto(key));
    }

    public boolean containsValue(Object value) {
        return this.inner_map.containsValue(JMap.auto(value));
    }

    public JObject get(JObject key) {
        return this.inner_map.get(key);
    }

    public JObject put(JObject key, JObject value) {
        return this.inner_map.put(key, value);
    }

    @Override
    public JObject put(Object key, Object value) {
        return this.inner_map.put(JMap.auto(key), JMap.auto(value));
    }

    @Override
    public JObject remove(Object key) {
        return (JObject)this.inner_map.remove(JMap.auto(key));
    }

    public void clear() {
        this.inner_map.clear();
    }

    public Set<JObject> keySet() {
        return this.inner_map.keySet();
    }

    public Collection<JObject> values() {
        return this.inner_map.values();
    }

    public Set<Map.Entry<JObject, JObject>> entrySet() {
        return this.inner_map.entrySet();
    }

    @Override
    public int hashCode() {
        return this.inner_map.hashCode();
    }

    @Override
    void toJson(Writer w, int deep, int indent) throws IOException {
        if (indent > 0) {
            String offset = "\r\n" + Utils.repeat(" ", (deep + 1) * indent);
            w.append('{');
            int cnt = this.inner_map.size();
            if (cnt > 0) {
                for (Map.Entry<JObject, JObject> i : this.entrySet()) {
                    --cnt;
                    w.append(offset);
                    i.getKey().toJson(w, deep + 1, indent);
                    w.append(": ");
                    i.getValue().toJson(w, deep + 1, indent);
                    if (cnt <= 0) continue;
                    w.append(',');
                }
                w.append("\r\n" + Utils.repeat(" ", deep * indent));
                w.append('}');
            } else {
                w.append('}');
            }
        } else {
            w.append('{');
            int cnt = this.inner_map.size();
            if (cnt > 0) {
                for (Map.Entry<JObject, JObject> i : this.entrySet()) {
                    i.getKey().toJson(w, deep + 1, indent);
                    w.append(": ");
                    i.getValue().toJson(w, deep + 1, indent);
                    if (--cnt <= 0) continue;
                    w.append(", ");
                }
                w.append('}');
            } else {
                w.append('}');
            }
        }
    }
}

