/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.Utils;
import com.easyeda.utils.json.JObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;

public final class JArray
extends JObject
implements Iterable<JObject> {
    private static final long serialVersionUID = -4614380302414967309L;
    private final LinkedList<JObject> inner_array = new LinkedList();

    @SafeVarargs
    public static <T> JArray build(T ... values) {
        JArray a = new JArray();
        for (T o : values) {
            a.add(o);
        }
        return a;
    }

    public JArray() {
    }

    public <T> JArray(Iterable<T> a) {
        this();
        for (T o : a) {
            this.add(o);
        }
    }

    public void add(JObject o) {
        this.inner_array.add(o);
    }

    @Override
    public void add(Object o) {
        this.add(JArray.auto(o));
    }

    public JObject get(int index) {
        return this.inner_array.get(index);
    }

    @Override
    public JArray asJArray() {
        return this;
    }

    public boolean equals(Object o) {
        if (o.getClass() == JArray.class) {
            JArray a = (JArray)o;
            return this.inner_array.equals(a.inner_array);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.inner_array.isEmpty();
    }

    public int size() {
        return this.inner_array.size();
    }

    @Override
    public Iterator<JObject> iterator() {
        return this.inner_array.iterator();
    }

    @Override
    public int hashCode() {
        return this.inner_array.hashCode();
    }

    @Override
    void toJson(Writer w, int deep, int indent) throws IOException {
        if (indent > 0) {
            w.append('[');
            String offset = "\r\n" + Utils.repeat(" ", (deep + 1) * indent);
            int cnt = this.inner_array.size();
            if (cnt > 0) {
                for (JObject o : this.inner_array) {
                    w.append(offset);
                    o.toJson(w, deep + 1, indent);
                    if (--cnt <= 0) continue;
                    w.append(",");
                }
                w.append("\r\n");
                w.append(Utils.repeat(" ", deep * indent));
                w.append(']');
            } else {
                w.append(']');
            }
        } else {
            w.append('[');
            int cnt = this.inner_array.size();
            if (cnt > 0) {
                for (JObject o : this.inner_array) {
                    o.toJson(w, deep + 1, indent);
                    if (--cnt <= 0) continue;
                    w.append(", ");
                }
                w.append(']');
            } else {
                w.append(']');
            }
        }
    }
}

