/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils.json;

import com.easyeda.utils.json.InvalidJSON;
import com.easyeda.utils.json.JBool;
import com.easyeda.utils.json.JNull;
import com.easyeda.utils.json.JNumber;
import com.easyeda.utils.json.JObject;
import com.easyeda.utils.json.JString;
import java.util.ArrayDeque;

public abstract class AbstractJsonParser {
    private STAT state = STAT.UNKNOW;
    private final ArrayDeque<StringBuilder> buffer_stack = new ArrayDeque();

    protected void _feed(char c) throws InvalidJSON {
        block1 : switch (this.state) {
            case UNKNOW: {
                switch (c) {
                    case '\"': {
                        this.state = STAT.INSTRING;
                        this.startNewBuffer();
                        break block1;
                    }
                    case '{': {
                        this.onMapStart();
                        break block1;
                    }
                    case '}': {
                        this.onMapEnd();
                        break block1;
                    }
                    case '[': {
                        this.onArrayStart();
                        break block1;
                    }
                    case ']': {
                        this.onArrayEnd();
                        break block1;
                    }
                    case 'T': 
                    case 't': {
                        this.state = STAT.T;
                        break block1;
                    }
                    case 'F': 
                    case 'f': {
                        this.state = STAT.F;
                        break block1;
                    }
                    case 'N': 
                    case 'n': {
                        this.state = STAT.N;
                        break block1;
                    }
                    case '\u0000': 
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': {
                        break block1;
                    }
                }
                if ('0' <= c && c <= '9' || c == '-') {
                    this.state = STAT.INNUMBER;
                    this.startNewBuffer();
                    this.buffer_stack.peek().append(c);
                    break;
                }
                throw new InvalidJSON();
            }
            case INSTRING: {
                switch (c) {
                    case '\"': {
                        this.state = STAT.UNKNOW;
                        this.onJObject(new JString(this.getReleaseBuffer()));
                        break block1;
                    }
                    case '\\': {
                        this.state = STAT.INSTRING_ESCAPE;
                        break block1;
                    }
                }
                this.buffer_stack.peek().append(c);
                break;
            }
            case INSTRING_ESCAPE: {
                switch (c) {
                    case 'b': {
                        this.state = STAT.INSTRING;
                        this.buffer_stack.peek().append('\b');
                        break block1;
                    }
                    case 'f': {
                        this.state = STAT.INSTRING;
                        this.buffer_stack.peek().append('\f');
                        break block1;
                    }
                    case 'r': {
                        this.state = STAT.INSTRING;
                        this.buffer_stack.peek().append('\r');
                        break block1;
                    }
                    case 'n': {
                        this.state = STAT.INSTRING;
                        this.buffer_stack.peek().append('\n');
                        break block1;
                    }
                    case 't': {
                        this.state = STAT.INSTRING;
                        this.buffer_stack.peek().append('\t');
                        break block1;
                    }
                    case 'u': {
                        this.state = STAT.INSTRING_ESCAPE_UNICODE;
                        this.startNewBuffer();
                        break block1;
                    }
                }
                this.state = STAT.INSTRING;
                this.buffer_stack.peek().append(c);
                break;
            }
            case INSTRING_ESCAPE_UNICODE: {
                if (this.isHexDigit(c)) {
                    this.buffer_stack.peek().append(c);
                    if (this.buffer_stack.peek().length() != 4) break;
                    String hex_number = this.getReleaseBuffer();
                    this.buffer_stack.peek().append((char)Integer.parseInt(hex_number, 16));
                    this.state = STAT.INSTRING;
                    break;
                }
                throw new InvalidJSON("invalid unicode escape charactor");
            }
            case INNUMBER: {
                double number;
                if (this.isNumber(c)) {
                    this.buffer_stack.peek().append(c);
                    break;
                }
                try {
                    number = Double.parseDouble(this.getReleaseBuffer());
                }
                catch (NumberFormatException e) {
                    throw new InvalidJSON("invalid number format");
                }
                this.onJObject(new JNumber(number));
                this.state = STAT.UNKNOW;
                this._feed(c);
                break;
            }
            case T: {
                if (c == 'r' || c == 'R') {
                    this.state = STAT.TR;
                    break;
                }
                throw new InvalidJSON();
            }
            case TR: {
                if (c == 'u' || c == 'U') {
                    this.state = STAT.TRU;
                    break;
                }
                throw new InvalidJSON();
            }
            case TRU: {
                if (c == 'e' || c == 'E') {
                    this.state = STAT.UNKNOW;
                    this.onJObject(JBool.TRUE);
                    break;
                }
                throw new InvalidJSON();
            }
            case F: {
                if (c == 'a' || c == 'A') {
                    this.state = STAT.FA;
                    break;
                }
                throw new InvalidJSON();
            }
            case FA: {
                if (c == 'l' || c == 'L') {
                    this.state = STAT.FAL;
                    break;
                }
                throw new InvalidJSON();
            }
            case FAL: {
                if (c == 's' || c == 'S') {
                    this.state = STAT.FALS;
                    break;
                }
                throw new InvalidJSON();
            }
            case FALS: {
                if (c == 'e' || c == 'E') {
                    this.state = STAT.UNKNOW;
                    this.onJObject(JBool.FALSE);
                    break;
                }
                throw new InvalidJSON();
            }
            case N: {
                if (c == 'u' || c == 'U') {
                    this.state = STAT.NU;
                    break;
                }
                throw new InvalidJSON();
            }
            case NU: {
                if (c == 'l' || c == 'L') {
                    this.state = STAT.NUL;
                    break;
                }
                throw new InvalidJSON();
            }
            case NUL: {
                if (c == 'l' || c == 'L') {
                    this.state = STAT.UNKNOW;
                    this.onJObject(JNull.NULL);
                    break;
                }
                throw new InvalidJSON();
            }
            default: {
                throw new InvalidJSON("failed to parse JSON with bug.");
            }
        }
    }

    private void startNewBuffer() {
        this.buffer_stack.push(new StringBuilder());
    }

    private String getReleaseBuffer() {
        return this.buffer_stack.pop().toString();
    }

    private boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private boolean isNumber(char c) {
        return '0' <= c && c <= '9' || c == '.' || c == '+' || c == '-' || c == 'e' || c == 'E';
    }

    public STAT getState() {
        return this.state;
    }

    public void finish() throws InvalidJSON {
        this._feed('\u0000');
    }

    public abstract void onMapStart() throws InvalidJSON;

    public abstract void onArrayStart() throws InvalidJSON;

    public abstract void onMapEnd() throws InvalidJSON;

    public abstract void onArrayEnd() throws InvalidJSON;

    public abstract void onJObject(JObject var1) throws InvalidJSON;

    static enum STAT {
        UNKNOW,
        INSTRING,
        INSTRING_ESCAPE,
        INSTRING_ESCAPE_UNICODE,
        INNUMBER,
        T,
        TR,
        TRU,
        F,
        FA,
        FAL,
        FALS,
        N,
        NU,
        NUL;

    }
}

