/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils;

public class Validation {
    private static void exceptionOrPass(boolean cmp, String fmt, Object ... args) {
        if (cmp) {
            return;
        }
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException(fmt);
        }
        throw new IllegalArgumentException(String.format(fmt, args));
    }

    public static <T> T validate(T o, boolean cmp, String fmt, Object ... args) {
        Validation.exceptionOrPass(cmp, fmt, args);
        return o;
    }

    public static <T> T NPE(T o) {
        return Validation.validate(o, o != null, "null value is not permitted", new Object[0]);
    }

    public static <T> T[] NPEA(T[] c) {
        for (T t : Validation.NPE(c)) {
            Validation.NPE(t);
        }
        return c;
    }

    public static int validRGB(int o) {
        return Validation.validate(o, 0 <= o, "RGB should not nagative and not over 255(0xFF)", new Object[0]);
    }

    public static double validPositive(double o) {
        return Validation.validate(o, 0.0 <= o, "negative value is not permitted", new Object[0]);
    }

    public static String validStringNotEmpty(String s) {
        return Validation.validate(s, !Validation.nullOrEmpty(s), "null or empty is not permitted", new Object[0]);
    }

    public static int validPositive(int o) {
        return Validation.validate(o, 0 <= o, "negative value is not permitted", new Object[0]);
    }

    public static boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static double validNotNaN(double o) {
        if (Double.isNaN(o)) {
            throw new IllegalArgumentException("NaN is not permitted");
        }
        return o;
    }
}

