/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.utils;

import com.easyeda.utils.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static final String APP_PATH;
    private static final Pattern r_abs_url;

    public static String getClassPath(Class<?> cls) {
        try {
            return cls.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String join(String sperator, Iterator<?> iter) {
        return Utils.join(sperator, null, iter);
    }

    public static String join(String sperator, String initialPath, Iterator<?> iter) {
        StringBuilder sb = new StringBuilder();
        if (initialPath != null) {
            sb.append(initialPath);
            sb.append(sperator);
        }
        if (iter.hasNext()) {
            sb.append(iter.next().toString());
            while (iter.hasNext()) {
                sb.append(sperator);
                sb.append(iter.next().toString());
            }
            return sb.toString();
        }
        return "";
    }

    public static <T> String join(String sperator, List<T> l) {
        return Utils.join(sperator, l.iterator());
    }

    @SafeVarargs
    public static <T> String join(String sperator, T ... args) {
        return Utils.join(sperator, Arrays.asList(args).iterator());
    }

    public static String joinPath(String ... args) {
        return Utils.join(File.separator, args);
    }

    public static String joinAppPath(String ... args) {
        return Utils.join(File.separator, APP_PATH, Arrays.asList(args).iterator());
    }

    public static String repeat(String base, int times) {
        if (times <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(base.length() * times);
        for (int i = 0; i < times; ++i) {
            sb.append(base);
        }
        return sb.toString();
    }

    public static String repeat(char c, int times) {
        return Utils.repeat(Character.valueOf(c).toString(), times);
    }

    public static byte[] readAll(InputStream is) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Utils.streamTunnel(is, os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String path) throws IOException {
        char[] buffer = new char[8192];
        StringBuilder sb = new StringBuilder();
        try (FileReader fr = new FileReader(path);){
            while (fr.ready()) {
                int nread = fr.read(buffer);
                sb.append(buffer, 0, nread);
            }
        }
        return sb.toString();
    }

    public static String MD5(byte[] data) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        byte[] hash = md.digest(data);
        StringBuilder sb = new StringBuilder(hash.length * 2);
        for (int i = 0; i < hash.length; ++i) {
            sb.append(String.format("%02X", hash[i]));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void singleton(Singleton st) throws Exception {
        if (!st.isInitialized()) {
            Object object = st.getLocker();
            synchronized (object) {
                if (!st.isInitialized()) {
                    st.initialize();
                }
            }
        }
    }

    public static String UUID() {
        return UUID.randomUUID().toString();
    }

    public static void loadJarFile(File path) throws Exception {
        URL url = path.toURI().toURL();
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, url);
    }

    public static String getStackTrace(Throwable e) {
        return Utils.getStackTrace("", e);
    }

    private static String getStackTrace(String prefix, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + Utils.getStackTraceHead(e) + "\r\n");
        for (StackTraceElement ele : e.getStackTrace()) {
            sb.append(prefix + "    " + ele.toString() + "\r\n");
        }
        if (e.getCause() != null) {
            sb.append(prefix + " caused by:\r\n");
            sb.append(Utils.getStackTrace(prefix + "    ", e.getCause()) + "\r\n");
        }
        return sb.toString();
    }

    public static String getStackTraceHead(Throwable e) {
        String cls = e.getClass().getName();
        String msg = e.getMessage();
        if (msg == null) {
            return cls;
        }
        return String.format("%s: %s", cls, msg);
    }

    public static String resolveUrl(String base, String target) {
        if (r_abs_url.matcher(target).matches()) {
            return target;
        }
        Matcher m = r_abs_url.matcher(base);
        if (m.matches()) {
            String protocol = m.group(1);
            String domain = m.group(2);
            String uri = m.group(3);
            if (target.startsWith("/")) {
                return String.format("%s://%s%s", protocol, domain, target);
            }
            if (target.startsWith("?") || target.startsWith("#")) {
                return base + target;
            }
            if (uri == null) {
                return String.format("%s://%s/%s", protocol, domain, target);
            }
            int slashIdx = uri.lastIndexOf(47);
            if (slashIdx == -1) {
                return String.format("%s://%s%s/%s", protocol, domain, uri, target);
            }
            return String.format("%s://%s%s/%s", protocol, domain, uri.substring(0, slashIdx), target);
        }
        throw new UnsupportedOperationException("Invalid base url " + base);
    }

    public static String getExt(char sperator, String path) {
        int lastDotIdx;
        int lastSperatorIdx;
        int firstSpecialPart = Math.max(path.indexOf(35), path.indexOf(63));
        if (firstSpecialPart != -1) {
            path = path.substring(0, firstSpecialPart);
        }
        if ((lastSperatorIdx = path.lastIndexOf(sperator)) != -1) {
            path = path.substring(lastSperatorIdx);
        }
        if ((lastDotIdx = path.lastIndexOf(46)) != -1 && lastDotIdx + 1 < path.length()) {
            return path.substring(lastDotIdx + 1);
        }
        return "";
    }

    public static String getExt(String path) {
        return Utils.getExt('/', path);
    }

    public static byte[] base64Decode(String data) {
        return Base64.getDecoder().decode(data);
    }

    public static String base64Encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static String capitalize(String s) {
        return Utils.capitalize(s, 0);
    }

    public static String capitalize(String s, int startIndex) {
        char first = s.charAt(startIndex);
        if ('a' <= first && first <= 'z') {
            char[] data = s.toCharArray();
            data[startIndex] = (char)(first - 32);
            return String.valueOf(data);
        }
        return s;
    }

    public static String xmlEncode(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String xmlDecode(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        int quoteStart = -1;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (quoteStart >= 0) {
                String quote;
                if (c != ';') continue;
                switch (quote = s.substring(quoteStart + 1, i)) {
                    case "lt": {
                        sb.append('<');
                        break;
                    }
                    case "gt": {
                        sb.append('>');
                        break;
                    }
                    case "quot": {
                        sb.append('\"');
                        break;
                    }
                    case "apos": {
                        sb.append('\'');
                        break;
                    }
                    case "amp": {
                        sb.append('&');
                        break;
                    }
                    default: {
                        sb.append("&" + quote + ";");
                    }
                }
                quoteStart = -1;
                continue;
            }
            if (c == '&') {
                quoteStart = i;
                continue;
            }
            sb.append(c);
        }
        if (quoteStart >= 0) {
            sb.append(s.substring(quoteStart));
        }
        return sb.toString();
    }

    public static <T> T[] toArray(List<T> o, Class<T> cls) {
        if (o == null) {
            return null;
        }
        Object[] a = (Object[])Array.newInstance(cls, o.size());
        int index = 0;
        for (T i : o) {
            a[index++] = i;
        }
        return a;
    }

    public static <T> void addAll(List<T> l, T[] array) {
        for (T i : array) {
            l.add(i);
        }
    }

    /*
     * Exception decompiling
     */
    public static long fileCopy(String src, String dst) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String subStr(String src, int beginIndex, int endIndex) {
        int len = src.length();
        if (beginIndex < 0) {
            beginIndex = len + beginIndex;
        }
        if (endIndex < 0) {
            endIndex = len + endIndex + 1;
        }
        return src.substring(beginIndex, endIndex);
    }

    public static <T> T NVL(T src, T replacement) {
        return src == null ? replacement : src;
    }

    public static long streamTunnel(InputStream is, OutputStream os) throws IOException {
        int nread;
        long bytesCount = 0L;
        byte[] buffer = new byte[8192];
        while ((nread = is.read(buffer)) > 0) {
            os.write(buffer, 0, nread);
            bytesCount += (long)nread;
        }
        return bytesCount;
    }

    public static long writeFile(File f, InputStream is) throws FileNotFoundException, IOException {
        try (FileOutputStream os = new FileOutputStream(f);){
            long l = Utils.streamTunnel(is, os);
            return l;
        }
    }

    /*
     * Exception decompiling
     */
    public static long writeFile(File f, byte[] content) throws FileNotFoundException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String lpad(String src, char c, int length) {
        int offset = length - src.length();
        if (offset > 0) {
            return Utils.repeat(c, offset) + src;
        }
        return src;
    }

    public static String rpad(String src, char c, int length) {
        int offset = length - src.length();
        if (offset > 0) {
            return src + Utils.repeat(c, offset);
        }
        return src;
    }

    public static String replace(String src, String pattern, String replacement) {
        int i = src.indexOf(pattern);
        if (i >= 0) {
            int j;
            int ptnLen = pattern.length();
            StringBuilder sb = new StringBuilder(src.length());
            sb.append(src, 0, i).append(replacement);
            i += ptnLen;
            while ((j = src.indexOf(pattern, i)) >= 0) {
                sb.append(src, i, j).append(replacement);
                i = j + ptnLen;
            }
            return sb.append(src, i, src.length()).toString();
        }
        return src;
    }

    public static int cpus() {
        return Runtime.getRuntime().availableProcessors();
    }

    static {
        File parent = new File(Utils.getClassPath(Utils.class)).getParentFile();
        APP_PATH = parent.getName().equals("bin") ? parent.getParent() : parent.getAbsolutePath();
        r_abs_url = Pattern.compile("^([a-z0-9]+)://([^/]+)(/.*)?$", 2);
    }
}

