/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.router;

import com.easyeda.utils.json.JArray;
import com.easyeda.utils.json.JMap;
import com.easyeda.utils.json.JObject;

public class SessionFileUtil {
    public static JObject sessionFileToEasyEDA(String fileData) {
        JMap netArr = new JMap();
        if (fileData == null) {
            return netArr;
        }
        String[] nets = fileData.split("\\(net ");
        for (int i = 1; i < nets.length; ++i) {
            String[] netNodes = nets[i].split("\n");
            String netName = netNodes[0].trim();
            JMap item = new JMap();
            JArray wires = new JArray();
            JArray vias = new JArray();
            item.put("wires", (Object)wires);
            item.put("vias", (Object)vias);
            item.put("net", netName.replace("\"", ""));
            String[] maybeWireArr = nets[i].split("\\(path");
            for (int j = 1; j < maybeWireArr.length; ++j) {
                String[] lines = maybeWireArr[j].split("\n");
                String[] wireInfo = lines[0].trim().split(" ");
                int layerId = SessionFileUtil.parseInt(wireInfo[0].trim());
                int width = SessionFileUtil.parseInt(wireInfo[1].trim());
                JMap lineObj = new JMap();
                JArray linePoints = new JArray();
                lineObj.put("layerid", layerId);
                lineObj.put("width", SessionFileUtil.toEasyEDASize(width));
                lineObj.put("points", (Object)linePoints);
                for (int k = 1; k < lines.length; ++k) {
                    String[] points = lines[k].trim().split(" ");
                    int ptx = SessionFileUtil.parseInt(points[0].trim());
                    if (points.length != 2 || ptx <= 0) continue;
                    int pty = SessionFileUtil.parseInt(points[1].trim());
                    linePoints.add(SessionFileUtil.toEasyEDASize(ptx));
                    linePoints.add(SessionFileUtil.toEasyEDASize(pty));
                }
                wires.add(lineObj);
            }
            String[] maybeVia = nets[i].split("\\(via");
            for (int j = 1; j < maybeVia.length; ++j) {
                String t = maybeVia[j].trim();
                String[] ts = (t = t.substring(0, t.indexOf("\n")).trim()).split(" ");
                if (ts.length != 3) continue;
                int x = SessionFileUtil.parseInt(ts[1]);
                int y = SessionFileUtil.parseInt(ts[2]);
                if (x <= 0) continue;
                JMap viaObj = new JMap();
                viaObj.put("x", SessionFileUtil.toEasyEDASize(x));
                viaObj.put("y", SessionFileUtil.toEasyEDASize(y));
                vias.add(viaObj);
            }
            netArr.put("" + i, (Object)item);
        }
        return netArr;
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static double toEasyEDASize(double s) {
        return s / 1000.0;
    }
}

