/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.router;

import com.easyeda.router.WSService;
import com.easyeda.router.WhoIs;
import com.easyeda.utils.Config;
import com.easyeda.utils.json.JObject;
import java.io.IOException;
import java.net.BindException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHandler;

public class RouterServer {
    public static void main(String[] args) throws IOException {
        try {
            JObject web = Config.get("main.json").get("web");
            Server server = new Server();
            HttpConfiguration http_config = new HttpConfiguration();
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
            connector.setHost(web.get("ip").asString());
            connector.setPort(web.get("port").asInt());
            connector.setIdleTimeout((long)web.get("idle").asInt());
            server.setConnectors(new Connector[]{connector});
            ServletHandler handler = new ServletHandler();
            handler.addServletWithMapping(WhoIs.class, "/api/whois");
            handler.addServletWithMapping(WSService.class, "/router");
            server.setHandler((Handler)handler);
            server.start();
            System.out.println("Auto Router now running...");
            server.join();
        }
        catch (BindException e) {
            System.out.println("Auto Router is already running or Address is already in use");
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        System.out.print("press any key to close...");
        System.in.read();
        System.exit(1);
    }
}

