/*
 * Decompiled with CFR 0.152.
 */
package com.easyeda.router;

import board.BoardObservers;
import board.Component;
import board.Item;
import board.ItemIdNoGenerator;
import board.TestLevel;
import com.easyeda.router.RoutingClient;
import com.easyeda.utils.Config;
import com.easyeda.utils.json.JObject;
import designformats.specctra.DsnFile;
import interactive.BoardHandling;
import interactive.RouterCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.InvalidParameterException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class RouterExecutor
implements Runnable,
BoardObservers {
    private final RoutingClient client;
    private final BoardHandling bh;
    private final byte[] dsnFile;
    private final int timeout;
    private final int progressInterval;
    private final int heatbeatInterval;
    private volatile Thread myThread;
    private volatile long start;
    private volatile long deadline;
    private volatile long nextHeartbeat;
    private volatile long nextReportProgress;

    private static long currentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public RouterExecutor(RoutingClient client, byte[] dsnFile, int timeout, int progressInterval, int optimizeTimes) {
        JObject router = Config.get("main.json").get("router");
        this.heatbeatInterval = router.get("keep_heartbeat").asInt();
        int minTimeout = router.get("min_timeout").asInt();
        int minProgressInterval = router.get("min_progress_interval").asInt();
        this.client = client;
        this.bh = new BoardHandling(Locale.ENGLISH, optimizeTimes > 0 ? optimizeTimes : 3);
        this.dsnFile = dsnFile;
        this.timeout = Math.max(timeout, minTimeout);
        this.progressInterval = Math.max(progressInterval, minProgressInterval);
    }

    public void interrupt() {
        this.myThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.myThread = Thread.currentThread();
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.dsnFile);){
            this.client.sendRaw("{\"a\":\"heartbeat\"}\n");
            DsnFile.ReadResult read_result = this.bh.import_design(is, this, new ItemIdNoGenerator(), TestLevel.RELEASE_VERSION);
            if (read_result != DsnFile.ReadResult.OK) {
                throw new InvalidParameterException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.client.sendResult(-2, -1, null);
        }
        try {
            this.start = RouterExecutor.currentTimeMillis();
            this.deadline = this.start + (long)this.timeout;
            this.nextHeartbeat = this.start + (long)this.heatbeatInterval;
            this.nextReportProgress = this.start + (long)this.progressInterval;
            this.bh.start_batch_autorouter();
            while (!Thread.interrupted()) {
                ByteArrayOutputStream os;
                long current = RouterExecutor.currentTimeMillis();
                if (this.bh.isFinished) {
                    this.bh.terminate();
                    os = new ByteArrayOutputStream();
                    this.bh.export_specctra_session_file("tmp", os);
                    this.client.sendResult(1, this.bh.getInCompletesNum(), os.toString());
                    break;
                }
                if (this.bh.exception != null) {
                    throw this.bh.exception;
                }
                if (this.deadline <= current) {
                    this.bh.terminate();
                    os = new ByteArrayOutputStream();
                    this.bh.export_specctra_session_file("tmp", os);
                    this.client.sendResult(0, this.bh.getInCompletesNum(), os.toString());
                    break;
                }
                if (current >= this.nextHeartbeat) {
                    this.nextHeartbeat = current + (long)this.heatbeatInterval;
                    this.client.sendRaw("{\"a\":\"heartbeat\"}\n");
                } else if (current >= this.nextReportProgress) {
                    this.nextReportProgress = current + (long)this.progressInterval;
                    try {
                        RouterCache cache = this.bh.waitCurrentCache();
                        this.client.sendProgress(cache.inCompletesNum, cache.data);
                        this.nextHeartbeat = current + (long)this.heatbeatInterval;
                    }
                    catch (InterruptedException cache) {}
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.client.sendResult(-1, -1, null);
        }
        finally {
            try {
                this.bh.terminate();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void notify_deleted(Item p_object) {
    }

    @Override
    public void notify_changed(Item p_object) {
    }

    @Override
    public void notify_new(Item p_object) {
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public boolean is_active() {
        return false;
    }

    @Override
    public void notify_moved(Component p_component) {
    }
}

