/*
 * Decompiled with CFR 0.152.
 */
package test;

import board.BasicBoard;
import board.Item;
import board.PolylineTrace;
import board.SearchTreeObject;
import board.TestLevel;
import board.Trace;
import geometry.planar.IntOctagon;
import geometry.planar.IntPoint;
import geometry.planar.Polyline;
import geometry.planar.TileShape;
import java.util.Iterator;
import java.util.Set;

public class Validate {
    private static int[] last_violation_count = null;
    private static boolean first_time = true;
    private static int prev_stub_count = 0;

    public static boolean check(String p_s, BasicBoard p_board) {
        if (p_board.get_test_level() == TestLevel.RELEASE_VERSION) {
            return true;
        }
        boolean result = true;
        IntOctagon surr_oct = p_board.bounding_box.to_IntOctagon();
        int layer_count = p_board.get_layer_count();
        if (last_violation_count == null) {
            last_violation_count = new int[layer_count];
        }
        for (int layer = 0; layer < layer_count; ++layer) {
            int cl_count;
            if (first_time) {
                System.out.println(" validate board is on ");
                first_time = false;
            }
            Set<SearchTreeObject> l = p_board.overlapping_objects(surr_oct, layer);
            Iterator i = l.iterator();
            int clearance_violation_count = 0;
            int conflict_ob_count = 0;
            int trace_count = 0;
            while (i.hasNext()) {
                Item item = (Item)i.next();
                if (!item.validate()) {
                    System.out.println(p_s);
                }
                if ((cl_count = item.clearance_violation_count()) > 0) {
                    ++conflict_ob_count;
                    clearance_violation_count += cl_count;
                }
                if (!(item instanceof PolylineTrace)) continue;
                ++trace_count;
            }
            if (conflict_ob_count == 1) {
                System.out.println("conflicts not symmetric");
            }
            if (clearance_violation_count != last_violation_count[layer]) {
                result = false;
                System.out.print(clearance_violation_count);
                System.out.print(" clearance violations on layer ");
                System.out.print(layer);
                System.out.print(" ");
                System.out.println(p_s);
                if (clearance_violation_count > 0) {
                    System.out.print("with items of nets: ");
                }
                for (Item item : l) {
                    PolylineTrace curr_trace;
                    cl_count = item.clearance_violation_count();
                    if (cl_count == 0) continue;
                    int curr_net_no = 0;
                    if (item instanceof PolylineTrace && (curr_trace = (PolylineTrace)item).net_count() > 0) {
                        curr_net_no = curr_trace.get_net_no(0);
                    }
                    System.out.print(curr_net_no);
                    System.out.print(", ");
                }
                System.out.println();
            }
            if (clearance_violation_count == last_violation_count[layer]) continue;
            Validate.last_violation_count[layer] = clearance_violation_count;
        }
        return result;
    }

    public static boolean check(String p_s, BasicBoard p_board, Polyline p_polyline, int p_layer, int p_half_width, int[] p_net_no_arr, int p_cl_type) {
        TileShape[] offset_shapes = p_polyline.offset_shapes(p_half_width, 0, p_polyline.arr.length - 1);
        for (int i = 0; i < offset_shapes.length; ++i) {
            Set<Item> obstacles = p_board.search_tree_manager.get_default_tree().overlapping_items_with_clearance(offset_shapes[i], p_layer, p_net_no_arr, p_cl_type);
            for (Item curr_obs : obstacles) {
                if (curr_obs.shares_net_no(p_net_no_arr)) continue;
                System.out.print(p_s);
                System.out.println(": cannot insert trace without violations");
                return false;
            }
        }
        return true;
    }

    public static void orthogonal(String p_s, BasicBoard p_board) {
        for (Item curr_ob : p_board.get_items()) {
            PolylineTrace curr_trace;
            if (!(curr_ob instanceof PolylineTrace) || (curr_trace = (PolylineTrace)curr_ob).polyline().is_orthogonal()) continue;
            System.out.print(p_s);
            System.out.println(": trace not orthogonal");
            break;
        }
    }

    public static void multiple_of_45_degree(String p_s, BasicBoard p_board) {
        int count = 0;
        for (Item curr_ob : p_board.get_items()) {
            PolylineTrace curr_trace;
            if (!(curr_ob instanceof PolylineTrace) || (curr_trace = (PolylineTrace)curr_ob).polyline().is_multiple_of_45_degree()) continue;
            ++count;
        }
        if (count > 1) {
            System.out.print(p_s);
            System.out.print(count);
            System.out.println(" traces not 45 degree");
        }
    }

    public static boolean corners_on_grid(String p_s, Polyline p_polyline) {
        for (int i = 0; i < p_polyline.corner_count(); ++i) {
            if (p_polyline.corner(i) instanceof IntPoint) continue;
            System.out.print(p_s);
            System.out.println(": corner not on grid");
            return false;
        }
        return true;
    }

    public static int stub_count(String p_s, BasicBoard p_board, int p_net_no) {
        if (first_time) {
            System.out.println(" stub_count is on ");
            first_time = false;
        }
        int result = 0;
        for (Item curr_ob : p_board.get_items()) {
            PolylineTrace curr_trace;
            if (!(curr_ob instanceof PolylineTrace) || !(curr_trace = (PolylineTrace)curr_ob).contains_net(p_net_no)) continue;
            if (curr_trace.get_start_contacts().size() == 0) {
                ++result;
            }
            if (curr_trace.get_end_contacts().size() != 0) continue;
            ++result;
        }
        if (result != prev_stub_count) {
            System.out.print(result + " stubs ");
            System.out.println(p_s);
            prev_stub_count = result;
        }
        return result;
    }

    public static boolean has_cycles(String p_s, BasicBoard p_board) {
        boolean result = false;
        for (Item curr_item : p_board.get_items()) {
            if (!(curr_item instanceof Trace) || !((Trace)curr_item).is_cycle()) continue;
            System.out.print(p_s);
            System.out.println(": cycle found");
            result = true;
            break;
        }
        return result;
    }

    public static boolean trace_count_exceeded(String p_s, BasicBoard p_board, int p_net_no, int p_max_count) {
        int found_traces = 0;
        for (Item curr_ob : p_board.get_items()) {
            if (!(curr_ob instanceof Trace) || !((Trace)curr_ob).contains_net(p_net_no)) continue;
            ++found_traces;
        }
        if (found_traces > p_max_count) {
            System.out.print(p_s);
            System.out.print(": ");
            System.out.print(p_max_count);
            System.out.println(" traces exceeded");
            return true;
        }
        return false;
    }

    public static boolean unconnnected_routing_items(String p_s, BasicBoard p_board) {
        for (Item curr_item : p_board.get_items()) {
            Set<Item> contact_list;
            if (!curr_item.is_route() || (contact_list = curr_item.get_normal_contacts()).size() != 0) continue;
            System.out.print(p_s);
            System.out.print(": uncontacted routing item found ");
            return true;
        }
        return false;
    }
}

