/*
 * Decompiled with CFR 0.152.
 */
package rules;

import board.ObjectInfoPanel;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import library.Padstack;
import rules.ViaInfo;

public class ViaRule
implements Serializable,
ObjectInfoPanel.Printable {
    public static final ViaRule EMPTY = new ViaRule("empty");
    public final String name;
    private List<ViaInfo> list = new LinkedList<ViaInfo>();

    public ViaRule(String p_name) {
        this.name = p_name;
    }

    public void append_via(ViaInfo p_via) {
        this.list.add(p_via);
    }

    public boolean remove_via(ViaInfo p_via) {
        return this.list.remove(p_via);
    }

    public int via_count() {
        return this.list.size();
    }

    public ViaInfo get_via(int p_index) {
        assert (p_index >= 0 && p_index < this.list.size());
        return this.list.get(p_index);
    }

    public String toString() {
        return this.name;
    }

    public boolean contains(ViaInfo p_via_info) {
        for (ViaInfo curr_info : this.list) {
            if (p_via_info != curr_info) continue;
            return true;
        }
        return false;
    }

    public boolean contains_padstack(Padstack p_padstack) {
        for (ViaInfo curr_info : this.list) {
            if (curr_info.get_padstack() != p_padstack) continue;
            return true;
        }
        return false;
    }

    public ViaInfo get_layer_range(int p_from_layer, int p_to_layer) {
        for (ViaInfo curr_info : this.list) {
            if (curr_info.get_padstack().from_layer() != p_from_layer || curr_info.get_padstack().to_layer() != p_to_layer) continue;
            return curr_info;
        }
        return null;
    }

    public boolean swap(ViaInfo p_1, ViaInfo p_2) {
        int index_1 = this.list.indexOf(p_1);
        int index_2 = this.list.indexOf(p_2);
        if (index_1 < 0 || index_2 < 0) {
            return false;
        }
        if (index_1 == index_2) {
            return true;
        }
        this.list.set(index_1, p_2);
        this.list.set(index_2, p_1);
        return true;
    }

    @Override
    public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("board.resources.ObjectInfoPanel", p_locale);
        p_window.append_bold(resources.getString("via_rule_2") + " ");
        p_window.append_bold(this.name);
        p_window.append_bold(":");
        int counter = 0;
        boolean first_time = true;
        int max_vias_per_row = 5;
        for (ViaInfo curr_via : this.list) {
            if (first_time) {
                first_time = false;
            } else {
                p_window.append(", ");
            }
            if (counter == 0) {
                p_window.newline();
                p_window.indent();
            }
            p_window.append(curr_via.get_name(), resources.getString("via_info"), curr_via);
            counter = (counter + 1) % 5;
        }
    }
}

