/*
 * Decompiled with CFR 0.152.
 */
package rules;

import board.BasicBoard;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import rules.Net;

public class Nets
implements Serializable {
    public static final int max_legal_net_no = 9999999;
    public static final int hidden_net_no = 10000001;
    private Vector<Net> net_arr = new Vector();
    private BasicBoard board;

    public int max_net_no() {
        return this.net_arr.size();
    }

    public Net get(String p_name, int p_subnet_number) {
        for (Net curr_net : this.net_arr) {
            if (curr_net == null || curr_net.name.compareToIgnoreCase(p_name) != 0 || curr_net.subnet_number != p_subnet_number) continue;
            return curr_net;
        }
        return null;
    }

    public Collection<Net> get(String p_name) {
        LinkedList<Net> result = new LinkedList<Net>();
        for (Net curr_net : this.net_arr) {
            if (curr_net == null || curr_net.name.compareToIgnoreCase(p_name) != 0) continue;
            result.add(curr_net);
        }
        return result;
    }

    public Net get(int p_net_no) {
        if (p_net_no < 1 || p_net_no > this.net_arr.size()) {
            return null;
        }
        Net result = this.net_arr.elementAt(p_net_no - 1);
        if (result != null && result.net_number != p_net_no) {
            System.out.println("Nets.get: inconsistent net_no");
        }
        return result;
    }

    public Net new_net(Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("rules.resources.Default", p_locale);
        String net_name = resources.getString("net#") + new Integer(this.net_arr.size() + 1).toString();
        return this.add(net_name, 1, false);
    }

    public Net add(String p_name, int p_subnet_number, boolean p_contains_plane) {
        int new_net_no = this.net_arr.size() + 1;
        if (new_net_no >= 9999999) {
            System.out.println("Nets.add_net: max_net_no out of range");
        }
        Net new_net = new Net(p_name, p_subnet_number, new_net_no, this, p_contains_plane);
        this.net_arr.add(new_net);
        return new_net;
    }

    public static boolean is_normal_net_no(int p_net_no) {
        return p_net_no > 0 && p_net_no <= 9999999;
    }

    public void set_board(BasicBoard p_board) {
        this.board = p_board;
    }

    public BasicBoard get_board() {
        return this.board;
    }
}

