/*
 * Decompiled with CFR 0.152.
 */
package rules;

import board.LayerStructure;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import rules.ClearanceMatrix;
import rules.NetClass;
import rules.ViaRule;

public class NetClasses
implements Serializable {
    private final Vector<NetClass> class_arr = new Vector();

    public int count() {
        return this.class_arr.size();
    }

    public NetClass get(int p_index) {
        assert (p_index >= 0 && p_index <= this.class_arr.size() - 1);
        return this.class_arr.get(p_index);
    }

    public NetClass get(String p_name) {
        for (NetClass curr_class : this.class_arr) {
            if (!curr_class.get_name().equals(p_name)) continue;
            return curr_class;
        }
        return null;
    }

    NetClass append(String p_name, LayerStructure p_layer_structure, ClearanceMatrix p_clearance_matrix) {
        NetClass new_class = new NetClass(p_name, p_layer_structure, p_clearance_matrix);
        this.class_arr.add(new_class);
        return new_class;
    }

    NetClass append(LayerStructure p_layer_structure, ClearanceMatrix p_clearance_matrix, Locale p_locale) {
        ResourceBundle resources = ResourceBundle.getBundle("rules.resources.Default", p_locale);
        String name_front = resources.getString("class");
        String new_name = null;
        Integer index = 0;
        do {
            index = index + 1;
        } while (this.get(new_name = name_front + index.toString()) != null);
        return this.append(new_name, p_layer_structure, p_clearance_matrix);
    }

    public NetClass find(int p_trace_half_width, int p_trace_clearance_class, ViaRule p_via_rule) {
        for (NetClass curr_class : this.class_arr) {
            if (curr_class.get_trace_clearance_class() != p_trace_clearance_class || curr_class.get_via_rule() != p_via_rule) continue;
            boolean trace_widths_equal = true;
            for (int i = 0; i < curr_class.layer_count(); ++i) {
                if (curr_class.get_trace_half_width(i) == p_trace_half_width) continue;
                trace_widths_equal = false;
                break;
            }
            if (!trace_widths_equal) continue;
            return curr_class;
        }
        return null;
    }

    public NetClass find(int[] p_trace_half_width_arr, int p_trace_clearance_class, ViaRule p_via_rule) {
        for (NetClass curr_class : this.class_arr) {
            if (curr_class.get_trace_clearance_class() != p_trace_clearance_class || curr_class.get_via_rule() != p_via_rule || p_trace_half_width_arr.length != curr_class.layer_count()) continue;
            boolean trace_widths_equal = true;
            for (int i = 0; i < curr_class.layer_count(); ++i) {
                if (curr_class.get_trace_half_width(i) == p_trace_half_width_arr[i]) continue;
                trace_widths_equal = false;
                break;
            }
            if (!trace_widths_equal) continue;
            return curr_class;
        }
        return null;
    }

    public boolean remove(NetClass p_net_class) {
        return this.class_arr.remove(p_net_class);
    }
}

