/*
 * Decompiled with CFR 0.152.
 */
package rules;

import board.LayerStructure;
import board.ObjectInfoPanel;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public class ClearanceMatrix
implements Serializable {
    private int class_count;
    private final LayerStructure layer_structure;
    private Row[] row;
    private int[] max_value_on_layer;

    public static ClearanceMatrix get_default_instance(LayerStructure p_layer_structure, int p_default_value) {
        String[] name_arr = new String[]{"null", "default"};
        ClearanceMatrix result = new ClearanceMatrix(2, p_layer_structure, name_arr);
        result.set_default_value(p_default_value);
        return result;
    }

    public ClearanceMatrix(int p_class_count, LayerStructure p_layer_structure, String[] p_name_arr) {
        this.class_count = Math.max(p_class_count, 1);
        this.layer_structure = p_layer_structure;
        this.row = new Row[this.class_count];
        for (int i = 0; i < this.class_count; ++i) {
            this.row[i] = new Row(p_name_arr[i]);
        }
        this.max_value_on_layer = new int[this.layer_structure.arr.length];
    }

    public int get_no(String p_name) {
        for (int i = 0; i < this.class_count; ++i) {
            if (this.row[i].name.compareToIgnoreCase(p_name) != 0) continue;
            return i;
        }
        return -1;
    }

    public String get_name(int p_cl_class) {
        if (p_cl_class < 0 || p_cl_class >= this.row.length) {
            System.out.println("CleatranceMatrix.get_name: p_cl_class out of range");
            return null;
        }
        return this.row[p_cl_class].name;
    }

    public void set_default_value(int p_value) {
        for (int i = 0; i < this.layer_structure.arr.length; ++i) {
            this.set_default_value(i, p_value);
        }
    }

    public void set_default_value(int p_layer, int p_value) {
        for (int i = 1; i < this.class_count; ++i) {
            for (int j = 1; j < this.class_count; ++j) {
                this.set_value(i, j, p_layer, p_value);
            }
        }
    }

    public void set_value(int p_i, int p_j, int p_value) {
        for (int layer = 0; layer < this.layer_structure.arr.length; ++layer) {
            this.set_value(p_i, p_j, layer, p_value);
        }
    }

    public void set_inner_value(int p_i, int p_j, int p_value) {
        for (int layer = 1; layer < this.layer_structure.arr.length - 1; ++layer) {
            this.set_value(p_i, p_j, layer, p_value);
        }
    }

    public void set_value(int p_i, int p_j, int p_layer, int p_value) {
        Row curr_row = this.row[p_j];
        MatrixEntry curr_entry = curr_row.column[p_i];
        int value = Math.max(p_value, 0);
        value += value % 2;
        curr_entry.layer[p_layer] = value;
        curr_row.max_value[p_layer] = Math.max(curr_row.max_value[p_layer], p_value);
        this.max_value_on_layer[p_layer] = Math.max(this.max_value_on_layer[p_layer], p_value);
    }

    public int value(int p_i, int p_j, int p_layer) {
        if (p_i < 0 || p_i >= this.class_count || p_j < 0 || p_j >= this.class_count || p_layer < 0 || p_layer >= this.layer_structure.arr.length) {
            return 0;
        }
        return this.row[p_j].column[p_i].layer[p_layer];
    }

    public int max_value(int p_i, int p_layer) {
        int i = Math.max(p_i, 0);
        i = Math.min(i, this.class_count - 1);
        int layer = Math.max(p_layer, 0);
        layer = Math.min(layer, this.layer_structure.arr.length - 1);
        return this.row[i].max_value[layer];
    }

    public int max_value(int p_layer) {
        int layer = Math.max(p_layer, 0);
        layer = Math.min(layer, this.layer_structure.arr.length - 1);
        return this.max_value_on_layer[layer];
    }

    public boolean is_layer_dependent(int p_i, int p_j) {
        int compare_value = this.row[p_j].column[p_i].layer[0];
        for (int l = 1; l < this.layer_structure.arr.length; ++l) {
            if (this.row[p_j].column[p_i].layer[l] == compare_value) continue;
            return true;
        }
        return false;
    }

    public boolean is_inner_layer_dependent(int p_i, int p_j) {
        if (this.layer_structure.arr.length <= 2) {
            return false;
        }
        int compare_value = this.row[p_j].column[p_i].layer[1];
        for (int l = 2; l < this.layer_structure.arr.length - 1; ++l) {
            if (this.row[p_j].column[p_i].layer[l] == compare_value) continue;
            return true;
        }
        return false;
    }

    public Row get_row(int p_no) {
        if (p_no < 0 || p_no >= this.row.length) {
            System.out.println("ClearanceMatrix.get_row: p_no out of range");
            return null;
        }
        return this.row[p_no];
    }

    public int get_class_count() {
        return this.class_count;
    }

    public int get_layer_count() {
        return this.layer_structure.arr.length;
    }

    public int clearance_compensation_value(int p_clearance_class_no, int p_layer) {
        return (this.value(p_clearance_class_no, p_clearance_class_no, p_layer) + 1) / 2;
    }

    public boolean append_class(String p_class_name) {
        int i;
        if (this.get_no(p_class_name) >= 0) {
            return false;
        }
        int old_class_count = this.class_count++;
        Row[] new_row = new Row[this.class_count];
        for (i = 0; i < old_class_count; ++i) {
            Row curr_old_row = this.row[i];
            new_row[i] = new Row(curr_old_row.name);
            Row curr_new_row = new_row[i];
            curr_new_row.max_value = curr_old_row.max_value;
            for (int j = 0; j < old_class_count; ++j) {
                curr_new_row.column[j] = curr_old_row.column[j];
            }
            curr_new_row.column[old_class_count] = new MatrixEntry();
        }
        new_row[old_class_count] = new Row(p_class_name);
        this.row = new_row;
        for (i = 0; i < old_class_count; ++i) {
            for (int j = 0; j < this.layer_structure.arr.length; ++j) {
                int default_value = this.value(1, i, j);
                this.set_value(old_class_count, i, j, default_value);
                this.set_value(i, old_class_count, j, default_value);
            }
        }
        for (int j = 0; j < this.layer_structure.arr.length; ++j) {
            int default_value = this.value(1, 1, j);
            this.set_value(old_class_count, old_class_count, j, default_value);
        }
        return true;
    }

    void remove_class(int p_index) {
        int old_class_count = this.class_count--;
        Row[] new_row = new Row[this.class_count];
        int new_row_index = 0;
        for (int i = 0; i < old_class_count; ++i) {
            if (i == p_index) continue;
            Row curr_old_row = this.row[i];
            new_row[new_row_index] = new Row(curr_old_row.name);
            Row curr_new_row = new_row[new_row_index];
            int new_column_index = 0;
            for (int j = 0; j < old_class_count; ++j) {
                if (j == p_index) continue;
                curr_new_row.column[new_column_index] = curr_old_row.column[j];
                ++new_column_index;
            }
            ++new_row_index;
        }
        this.row = new_row;
    }

    public boolean is_equal(int p_1, int p_2) {
        if (p_1 == p_2) {
            return true;
        }
        if (p_1 < 0 || p_2 < 0 || p_1 >= this.class_count || p_2 >= this.class_count) {
            return false;
        }
        Row row_1 = this.row[p_1];
        Row row_2 = this.row[p_2];
        for (int i = 1; i < this.class_count; ++i) {
            if (row_1.column[i].equals(row_2.column[i])) continue;
            return false;
        }
        return true;
    }

    private class MatrixEntry
    implements Serializable {
        int[] layer;

        private MatrixEntry() {
            this.layer = new int[((ClearanceMatrix)ClearanceMatrix.this).layer_structure.arr.length];
            for (int i = 0; i < ((ClearanceMatrix)ClearanceMatrix.this).layer_structure.arr.length; ++i) {
                this.layer[i] = 0;
            }
        }

        boolean equals(MatrixEntry p_other) {
            for (int i = 0; i < ((ClearanceMatrix)ClearanceMatrix.this).layer_structure.arr.length; ++i) {
                if (this.layer[i] == p_other.layer[i]) continue;
                return false;
            }
            return true;
        }

        boolean is_layer_dependent() {
            int compare_value = this.layer[0];
            for (int i = 1; i < ((ClearanceMatrix)ClearanceMatrix.this).layer_structure.arr.length; ++i) {
                if (this.layer[i] == compare_value) continue;
                return true;
            }
            return false;
        }
    }

    private class Row
    implements ObjectInfoPanel.Printable,
    Serializable {
        final String name;
        int[] max_value;
        final MatrixEntry[] column;

        private Row(String p_name) {
            this.name = p_name;
            this.column = new MatrixEntry[ClearanceMatrix.this.class_count];
            for (int i = 0; i < ClearanceMatrix.this.class_count; ++i) {
                this.column[i] = new MatrixEntry();
            }
            this.max_value = new int[((ClearanceMatrix)ClearanceMatrix.this).layer_structure.arr.length];
        }

        @Override
        public void print_info(ObjectInfoPanel p_window, Locale p_locale) {
            ResourceBundle resources = ResourceBundle.getBundle("board.resources.ObjectInfoPanel", p_locale);
            p_window.append_bold(resources.getString("spacing_from_clearance_class") + " ");
            p_window.append_bold(this.name);
            for (int i = 1; i < this.column.length; ++i) {
                p_window.newline();
                p_window.indent();
                p_window.append(" " + resources.getString("to_class") + " ");
                p_window.append(((ClearanceMatrix)ClearanceMatrix.this).row[i].name);
                MatrixEntry curr_column = this.column[i];
                if (curr_column.is_layer_dependent()) {
                    p_window.append(" " + resources.getString("on_layer") + " ");
                    for (int j = 0; j < ((ClearanceMatrix)ClearanceMatrix.this).layer_structure.arr.length; ++j) {
                        p_window.newline();
                        p_window.indent();
                        p_window.indent();
                        p_window.append(((ClearanceMatrix)ClearanceMatrix.this).layer_structure.arr[j].name);
                        p_window.append(" = ");
                        p_window.append(curr_column.layer[j]);
                    }
                    continue;
                }
                p_window.append(" = ");
                p_window.append(curr_column.layer[0]);
            }
        }
    }
}

