/*
 * Decompiled with CFR 0.152.
 */
package library;

import board.BasicBoard;
import board.DrillItem;
import datastructures.UndoableObjects;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import library.LogicalParts;
import library.Package;
import library.Packages;
import library.Padstack;
import library.Padstacks;

public class BoardLibrary
implements Serializable {
    public Padstacks padstacks = null;
    public Packages packages = null;
    public LogicalParts logical_parts = new LogicalParts();
    private List<Padstack> via_padstacks = null;

    public BoardLibrary(Padstacks p_padstacks, Packages p_packages) {
        this.padstacks = p_padstacks;
        this.packages = p_packages;
        this.logical_parts = new LogicalParts();
    }

    public BoardLibrary() {
    }

    public void set_via_padstacks(Padstack[] p_padstacks) {
        this.via_padstacks = new Vector<Padstack>();
        for (int i = 0; i < p_padstacks.length; ++i) {
            this.via_padstacks.add(p_padstacks[i]);
        }
    }

    public int via_padstack_count() {
        if (this.via_padstacks == null) {
            return 0;
        }
        return this.via_padstacks.size();
    }

    public Padstack get_via_padstack(int p_no) {
        if (this.via_padstacks == null || p_no < 0 || p_no >= this.via_padstacks.size()) {
            return null;
        }
        return this.via_padstacks.get(p_no);
    }

    public Padstack get_via_padstack(String p_name) {
        if (this.via_padstacks == null) {
            return null;
        }
        for (Padstack curr_padstack : this.via_padstacks) {
            if (!curr_padstack.name.equals(p_name)) continue;
            return curr_padstack;
        }
        return null;
    }

    public Padstack[] get_via_padstacks() {
        if (this.via_padstacks == null) {
            return new Padstack[0];
        }
        Padstack[] result = new Padstack[this.via_padstacks.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.via_padstacks.get(i);
        }
        return result;
    }

    public boolean add_via_padstack(Padstack p_padstack) {
        if (this.get_via_padstack(p_padstack.name) != null) {
            return false;
        }
        this.via_padstacks.add(p_padstack);
        return true;
    }

    public boolean remove_via_padstack(Padstack p_padstack, BasicBoard p_board) {
        boolean result = this.via_padstacks.remove(p_padstack);
        return result;
    }

    public Padstack get_mirrored_via_padstack(Padstack p_via_padstack) {
        int layer_count = this.padstacks.board_layer_structure.arr.length;
        if (p_via_padstack.from_layer() == 0 && p_via_padstack.to_layer() == layer_count - 1) {
            return p_via_padstack;
        }
        int new_from_layer = layer_count - p_via_padstack.to_layer() - 1;
        int new_to_layer = layer_count - p_via_padstack.from_layer() - 1;
        for (Padstack curr_via_padstack : this.via_padstacks) {
            if (curr_via_padstack.from_layer() != new_from_layer || curr_via_padstack.to_layer() != new_to_layer) continue;
            return curr_via_padstack;
        }
        return null;
    }

    public boolean is_used(Padstack p_padstack, BasicBoard p_board) {
        UndoableObjects.Storable curr_item;
        Iterator<UndoableObjects.UndoableObjectNode> it = p_board.item_list.start_read_object();
        while ((curr_item = p_board.item_list.read_object(it)) != null) {
            if (!(curr_item instanceof DrillItem) || ((DrillItem)curr_item).get_padstack() != p_padstack) continue;
            return true;
        }
        for (int i = 1; i <= this.packages.count(); ++i) {
            Package curr_package = this.packages.get(i);
            for (int j = 0; j < curr_package.pin_count(); ++j) {
                if (curr_package.get_pin((int)j).padstack_no != p_padstack.no) continue;
                return true;
            }
        }
        return false;
    }
}

