/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import board.AngleRestriction;
import board.FixedState;
import board.RoutingBoard;
import geometry.planar.FloatPoint;
import geometry.planar.IntPoint;
import geometry.planar.Line;
import geometry.planar.Point;
import geometry.planar.Side;
import geometry.planar.TileShape;
import interactive.BoardHandling;
import interactive.CornerItemConstructionState;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.LogfileScope;
import java.util.Iterator;
import java.util.LinkedList;
import rules.BoardRules;

public class TileConstructionState
extends CornerItemConstructionState {
    public static TileConstructionState get_instance(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        return new TileConstructionState(p_location, p_parent_state, p_board_handling, p_logfile);
    }

    private TileConstructionState(FloatPoint p_location, InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.CREATING_TILE);
        }
        this.add_corner(p_location);
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        super.left_button_clicked(p_location);
        this.remove_concave_corners();
        return this;
    }

    @Override
    public InteractiveState process_logfile_point(FloatPoint p_point) {
        return this.left_button_clicked(p_point);
    }

    @Override
    public InteractiveState complete() {
        boolean construction_succeeded;
        this.remove_concave_corners_at_close();
        int corner_count = this.corner_list.size();
        boolean bl = construction_succeeded = corner_count > 2;
        if (construction_succeeded) {
            int cl_class;
            int layer;
            IntPoint first_corner;
            Line[] edge_lines = new Line[corner_count];
            Iterator it = this.corner_list.iterator();
            IntPoint prev_corner = first_corner = (IntPoint)it.next();
            for (int i = 0; i < corner_count - 1; ++i) {
                IntPoint next_corner = (IntPoint)it.next();
                edge_lines[i] = new Line((Point)prev_corner, next_corner);
                prev_corner = next_corner;
            }
            edge_lines[corner_count - 1] = new Line((Point)prev_corner, first_corner);
            TileShape obstacle_shape = TileShape.get_instance(edge_lines);
            RoutingBoard board = this.hdlg.get_routing_board();
            construction_succeeded = board.check_shape(obstacle_shape, layer = this.hdlg.settings.layer, new int[0], cl_class = BoardRules.clearance_class_none());
            if (construction_succeeded) {
                boolean bl2 = this.observers_activated = !this.hdlg.get_routing_board().observers_active();
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().start_notify_observers();
                }
                board.generate_snapshot();
                board.insert_obstacle(obstacle_shape, layer, cl_class, FixedState.UNFIXED);
                if (this.observers_activated) {
                    this.hdlg.get_routing_board().end_notify_observers();
                    this.observers_activated = false;
                }
            }
        }
        if (construction_succeeded) {
            // empty if block
        }
        if (this.logfile != null) {
            this.logfile.start_scope(LogfileScope.COMPLETE_SCOPE);
        }
        return this.return_state;
    }

    private void remove_concave_corners() {
        IntPoint prev_corner;
        Side last_corner_side;
        IntPoint[] corner_arr = new IntPoint[this.corner_list.size()];
        Iterator it = this.corner_list.iterator();
        for (int i = 0; i < corner_arr.length; ++i) {
            corner_arr[i] = (IntPoint)it.next();
        }
        int new_length = corner_arr.length;
        if (new_length < 3) {
            return;
        }
        IntPoint last_corner = corner_arr[new_length - 1];
        IntPoint curr_corner = corner_arr[new_length - 2];
        while (new_length > 2 && (last_corner_side = last_corner.side_of(prev_corner = corner_arr[new_length - 3], curr_corner)) != Side.ON_THE_LEFT) {
            if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() != AngleRestriction.FORTYFIVE_DEGREE) {
                corner_arr[new_length - 2] = last_corner;
            }
            --new_length;
            if (this.hdlg.get_routing_board().rules.get_trace_angle_restriction() == AngleRestriction.NINETY_DEGREE) {
                IntPoint prev_prev_corner = null;
                if (new_length >= 3) {
                    prev_prev_corner = corner_arr[new_length - 3];
                }
                corner_arr[new_length - 2] = prev_prev_corner != null && prev_prev_corner.x == prev_corner.x ? new IntPoint(prev_corner.x, last_corner.y) : new IntPoint(last_corner.x, prev_corner.y);
            }
            curr_corner = prev_corner;
        }
        if (new_length < corner_arr.length) {
            this.corner_list = new LinkedList();
            for (int i = 0; i < new_length; ++i) {
                this.corner_list.add(corner_arr[i]);
            }
        }
    }

    private void remove_concave_corners_at_close() {
        IntPoint last_corner;
        int new_length;
        this.add_corner_for_snap_angle();
        if (this.corner_list.size() < 4) {
            return;
        }
        IntPoint[] corner_arr = new IntPoint[this.corner_list.size()];
        Iterator it = this.corner_list.iterator();
        for (int i = 0; i < corner_arr.length; ++i) {
            corner_arr[i] = (IntPoint)it.next();
        }
        IntPoint first_corner = corner_arr[0];
        IntPoint second_corner = corner_arr[1];
        for (new_length = corner_arr.length; new_length > 3 && (last_corner = corner_arr[new_length - 1]).side_of(second_corner, first_corner) == Side.ON_THE_LEFT; --new_length) {
        }
        if (new_length != corner_arr.length) {
            this.corner_list = new LinkedList();
            for (int i = 0; i < new_length; ++i) {
                this.corner_list.add(corner_arr[i]);
            }
            this.add_corner_for_snap_angle();
        }
    }

    @Override
    public void display_default_message() {
    }
}

