/*
 * Decompiled with CFR 0.152.
 */
package interactive;

import geometry.planar.FloatPoint;
import interactive.BoardHandling;
import interactive.InteractiveState;
import interactive.Logfile;
import interactive.RouteState;
import java.awt.Color;
import java.awt.Graphics;
import rules.DefaultItemClearanceClasses;
import rules.NetClass;

public class StitchRouteState
extends RouteState {
    protected StitchRouteState(InteractiveState p_parent_state, BoardHandling p_board_handling, Logfile p_logfile) {
        super(p_parent_state, p_board_handling, p_logfile);
    }

    @Override
    public InteractiveState left_button_clicked(FloatPoint p_location) {
        return this.add_corner(p_location);
    }

    @Override
    public InteractiveState add_corner(FloatPoint p_location) {
        this.hdlg.get_routing_board().generate_snapshot();
        return super.add_corner(p_location);
    }

    @Override
    public InteractiveState mouse_moved() {
        super.mouse_moved();
        this.route.calc_nearest_target_point(this.hdlg.get_current_mouse_position());
        return this;
    }

    @Override
    public String get_help_id() {
        return "RouteState_StitchingRouteState";
    }

    @Override
    public void draw(Graphics p_graphics) {
        super.draw(p_graphics);
        if (this.route == null) {
            return;
        }
        FloatPoint[] draw_points = new FloatPoint[]{this.route.get_last_corner().to_float(), this.hdlg.get_current_mouse_position()};
        Color draw_color = this.hdlg.graphics_context.get_hilight_color();
        double display_width = this.hdlg.get_trace_halfwidth(this.route.net_no_arr[0], this.hdlg.settings.layer);
        int clearance_draw_width = 50;
        double radius_with_clearance = display_width;
        NetClass default_net_class = this.hdlg.get_routing_board().rules.get_default_net_class();
        int cl_class = default_net_class.default_item_clearance_classes.get(DefaultItemClearanceClasses.ItemClass.TRACE);
        this.hdlg.graphics_context.draw(draw_points, display_width, draw_color, p_graphics, 0.5);
        this.hdlg.graphics_context.draw_circle(draw_points[1], radius_with_clearance += (double)this.hdlg.get_routing_board().clearance_value(cl_class, cl_class, this.hdlg.settings.layer), clearance_draw_width, draw_color, p_graphics, 0.5);
    }
}

